% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsn.transcripts.plot.R
\name{lsn.transcripts.plot}
\alias{lsn.transcripts.plot}
\title{Plot of Gene Lesions and Transcripts}
\usage{
lsn.transcripts.plot(
  grin.res,
  gene = NULL,
  transTrack = TRUE,
  lsn.clrs = NULL,
  chrom = NULL,
  plot.start = NULL,
  plot.end = NULL,
  lesion.grp = NULL,
  spec.lsn.clr = NULL,
  extend.left = NULL,
  extend.right = NULL,
  expand = 5e-04,
  hg38.transcripts = NULL,
  hg38.cytoband = NULL
)
}
\arguments{
\item{grin.res}{GRIN results (Output of the \code{grin.stats()} function).}

\item{gene}{Gene symbol of interest.}

\item{transTrack}{Logical; if \code{FALSE}, the transcript track will be excluded (useful for plots of large genomic regions such as entire chromosome arms or bands).}

\item{lsn.clrs}{Optional named vector of lesion colors. If not provided, default colors from \code{default.grin.colors()} will be used.}

\item{chrom}{Chromosome number. Required when plotting a locus (used with \code{plot.start} and \code{plot.end}).}

\item{plot.start}{Start coordinate (in base pairs) of the locus of interest.}

\item{plot.end}{End coordinate (in base pairs) of the locus of interest.}

\item{lesion.grp}{Lesion group to include in locus plots. Only lesions from this group will be shown. Required when \code{chrom}, \code{plot.start}, and \code{plot.end} are specified.}

\item{spec.lsn.clr}{Optional color for highlighting the lesion group of interest in locus plots.}

\item{extend.left}{Optional numeric value to extend the left side of the transcripts track (for alignment adjustments).}

\item{extend.right}{Optional numeric value to extend the right side of the transcripts track (for alignment adjustments).}

\item{expand}{Numeric; controls the proportion of upstream and downstream regions included in the plot relative to gene coordinates. Default is \code{0.0005}. Set to \code{0} to plot the gene region only.}

\item{hg38.transcripts}{Transcripts data from AnnotationHub (hg38, version 110). Required if \code{transTrack = TRUE}.}

\item{hg38.cytoband}{Data frame of hg38 cytogenetic bands (start and end coordinates in base pairs).}
}
\value{
A multi-panel plot showing:
\itemize{
\item Lesions and transcripts for a gene (with GRIN statistics), or
\item Lesions and optional transcripts for a genomic locus, or
\item Lesions alone for large genomic regions if transcripts and GRIN panels are excluded.
}
}
\description{
The function can generate four types of lesion plots.
(1) If the \code{gene} argument is specified, the function returns a gene-level plot showing all lesions affecting the gene, along with the transcript track and GRIN statistics.
(2) If \code{chrom}, \code{plot.start}, and \code{plot.end} are specified, the function generates a locus-level plot for that genomic region, including the transcript track.
If \code{transTrack = FALSE}, the function can return similar plots without the transcript track (useful for large regions such as chromosome bands or entire chromosomes).
(3) If \code{lesion.grp} is specified, only lesions from that specific group will be shown in the plot.
(4) If \code{lesion.grp} is not specified, all lesion types will be displayed for the given locus.
}
\details{
The function returns a plot that displays lesions affecting either a gene or a user-defined genomic region. When plotting a gene:
\itemize{
\item The top panel shows all transcripts of certain gene or group of genes in a small region retrieved from Ensembl if transTrack=TRUE (default).
\item The middle panel visualizes lesions affecting the gene or locus, color-coded by type.
\item The bottom panel presents GRIN statistics, including the number of affected subjects, -log10(p), and -log10(q) values in case of gene plots.
}

When plotting a genomic locus (via \code{chrom}, \code{plot.start}, \code{plot.end}):
\itemize{
\item Only the transcripts track (if \code{transTrack = TRUE}) and lesion panel are shown.
\item GRIN statistics are omitted.
}

For large regions like cytobands or entire chromosomes, set \code{transTrack = FALSE} to avoid overcrowding from long transcript tracks.
}
\examples{
\donttest{
data(lesion_data)
data(hg38_gene_annotation)
data(hg38_chrom_size)
data(hg38_cytoband)

# run GRIN analysis using grin.stats function
grin.results=grin.stats(lesion_data,
                        hg38_gene_annotation,
                        hg38_chrom_size)

# Plots Showing Different Types of Lesions Affecting a region of Interest without plotting the
# transcripts track (this will allow plotting a larger locus of the chromosome such as a
# chromosome band (should specify transTrack = FALSE):
cdkn2a.locus=lsn.transcripts.plot(grin.results, transTrack = FALSE,
                                   hg38.cytoband=hg38_cytoband, chrom=9,
                                   plot.start=19900000, plot.end=25600000,
                                    lesion.grp = "loss", spec.lsn.clr = "blue")

 # Plots Showing Different Types of Lesions Affecting the whole chromosome:
 chrom.plot=lsn.transcripts.plot(grin.results, transTrack = FALSE,
                                 hg38.cytoband=hg38_cytoband, chrom=9,
                                 plot.start=1, plot.end=141000000)
}
}
\references{
Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link{grin.stats}}
}
\author{
Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}
}
