% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.ensembl.annotation.R
\name{get.ensembl.annotation}
\alias{get.ensembl.annotation}
\title{Get Ensembl Gene and Regulatory Features Annotation Data}
\usage{
get.ensembl.annotation(genome.assembly)
}
\arguments{
\item{genome.assembly}{Character string. Currently, only \code{"Human_GRCh38"} is supported.}
}
\value{
A list with three components:
\describe{
\item{gene.annotation}{Data frame of gene-level annotation.}
\item{reg.annotation.predicted}{Data frame of predicted regulatory features.}
\item{reg.annotation.validated}{Data frame of validated regulatory features (FANTOM5).}
}
}
\description{
Retrieves gene and regulatory feature annotation data from the Ensembl BioMart database
for the Human GRCh38 (hg38) genome assembly using the biomaRt package.
}
\details{
This function retrieves:
\itemize{
\item Gene annotation: Ensembl ID, chromosome, start/end positions, gene name, description, biotype, strand, and cytogenetic band.
\item Predicted regulatory features: Promoters, enhancers, CTCF binding sites, etc., from the Ensembl regulatory build.
\item Validated regulatory features: Experimentally confirmed enhancers and TSSs from the FANTOM5 project.
}
}
\examples{
\donttest{
hg38.ann <- get.ensembl.annotation("Human_GRCh38")
# gene level annotations:
hg38.genes <- hg38.ann$gene.annotation
# regulatory sequences from the ensembl genome build:
hg38.reg.pred <- hg38.ann$reg.annotation.predicted
# regulatory sequences from the FANTOM5 project:
hg38.reg.val <- hg38.ann$reg.annotation.validated
}
}
\references{
Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.

Zerbino, Daniel R., et al. (2015). The ensembl regulatory build.

Kinsella, Rhoda J., et al. (2011). Ensembl BioMarts: a hub for data retrieval across taxonomic space.
}
\seealso{
\code{\link[biomaRt]{useEnsembl}}, \code{\link[biomaRt]{getBM}}
}
\author{
Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}
}
