% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGPPfit.R
\name{plotGPPfit}
\alias{plotGPPfit}
\alias{plotGPPfit,ANY-method}
\title{Plots results of a (converged) model, with true and projected values.}
\usage{
plotGPPfit(
  fit,
  df,
  obvColName,
  obvName,
  outcomeName,
  starttime,
  timeColName,
  legendLoc = "topleft",
  xlabel = NULL,
  ylabel = NULL,
  actualdatacol = "black",
  preddatacol = "red",
  ...
)
}
\arguments{
\item{fit}{The fit results of the GPP stan model.}

\item{df}{The dataframe used in your model.}

\item{obvColName}{The column name that includes your observation of interest. Must be a string.}

\item{obvName}{The name of the specific observation of interest. Must be a string.}

\item{outcomeName}{The explanatory variable that is subjected to the counterfactual claim.}

\item{starttime}{The start time of the treatment effect.}

\item{timeColName}{The name of the column that includes your time variable.}

\item{legendLoc}{The preferred location of the legend in the final graph. Defaults to "topleft".}

\item{xlabel}{The label of the x-axis in the final graph. Defaults to input for 'timeColName'.}

\item{ylabel}{The preferred label of the y-axis in the final graph. Defaults to input for 'outcomeName'.}

\item{actualdatacol}{The preferred color for plotted line for actual data. Defaults to black.}

\item{preddatacol}{The preferred color for plotted line for predicted counterfactual data. Defaults to red.}

\item{...}{Further graphical parameters.}
}
\value{
A plot built in r-base
}
\description{
Takes the results of a Gaussian Process Projection fit and generates a linear plot of the actual and predicted counterfactual values
}
\seealso{
\code{\link{autoConverge}} \code{\link{GPP}} \code{\link{runMod}} \code{\link{writeMod}}
}
\author{
Devin P. Brown \email{devinpbrown96@gmail.com} and David Carlson \email{carlson.david@wustl.edu}
}
