% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.fbd.R
\name{sim.fbd.taxa}
\alias{sim.fbd.taxa}
\title{sim.fbd.taxa: Simulating fossilized birth-death trees on a fixed number of extant taxa.}
\usage{
sim.fbd.taxa(n, numbsim, lambda, mu, psi, frac = 1, complete = FALSE)
}
\arguments{
\item{n}{Number of extant sampled tips.}

\item{numbsim}{Number of trees to simulate.}

\item{lambda}{Speciation rate.}

\item{mu}{Extinction rate.}

\item{psi}{Fossil sampling rate.}

\item{frac}{Extant sampling fraction. When complete = FALSE, the actual (simulated) number of extant tips is n/frac, but only n tips are included
in the result (incomplete sampling). When complete = TRUE: all unsampled lineages are included, i.e. the final tree has n/frac extant tips.}

\item{complete}{whether to return the complete tree (with non-sampled lineages) or the reconstructed tree (with unsampled lineages removed).}
}
\value{
List of numbsim simulated SAtrees with n extant sampled tips.
}
\description{
sim.fbd.taxa: Simulating fossilized birth-death trees on a fixed number of extant taxa.
}
\examples{
n = 10
lambda = 2.0
mu = 0.5
psi = 0.6
numbsim = 2
if (requireNamespace("TreeSim", quietly = TRUE)) {
sim.fbd.taxa(n, numbsim, lambda, mu, psi)
}
}
\keyword{birth}
\keyword{death}
\keyword{fossilized}
