% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predicted_residuals.R
\name{predict.flexreg}
\alias{predict.flexreg}
\title{Predict Method for \code{`flexreg`} Objects}
\usage{
\method{predict}{flexreg}(
  object,
  newdata = NULL,
  n.new = NULL,
  cluster = FALSE,
  type = "response",
  estimate = "mean",
  q = NULL,
  ...
)
}
\arguments{
\item{object}{an object of class \code{`flexreg`}, usually the result of \code{\link{flexreg}} or \code{\link{flexreg_binom}} functions.}

\item{newdata}{an optional  \code{data.frame} containing variables with which to predict. If omitted, the fitted values are used.}

\item{n.new}{an optional vector containing the total number of trials with which to predict. It must be specified if \code{newdata} is not \code{NULL} and the
\code{\link{flexreg}} object is the result of the \code{\link{flexreg_binom}} function (i.e., the fitted model is binomial, beta-binomial, or flexible beta-binomial). The vector must have the same length as \code{nrow(newdata)}.}

\item{cluster}{a logical (with default \code{FALSE}).  The option \code{cluster = TRUE} is available only for \code{"FB"} and \code{"FBB"} models and allows to compute some component-specific predictions (see Details).}

\item{type}{a character indicating the type of prediction. Available options are: \code{"response"}, returning the marginal fitted mean of the response/relative response;
\code{"link"}, returning the linear predictor of the mean model;
\code{"precision"}, returning the fitted precision parameter;
\code{"overdispersion"}, returning the fitted overdispersion parameter;
\code{"variance"}, returning the fitted variance of the response.}

\item{estimate}{a character indicating the type of estimate. Available options are \code{"mean"} (default), \code{"median"}, and \code{"quantile"}.}

\item{q}{if \code{estimate = "quantile"}, a numeric value of probability in (0, 1).}

\item{...}{additional arguments. Currently not used.}
}
\value{
The function returns a \code{data.frame} of different dimensions depending on the type of prediction.
}
\description{
Method that computes various types of predictions from objects of class \code{`flexreg`}.
}
\details{
The \code{\link{predict}} method computes various types of predictions from objects of class \code{`flexreg`}.
If \code{type = "response"}, the function returns the marginal mean, i.e., \eqn{\mu}.
In case of models for continuous bounded responses with augmentation, the function returns also the overall mean
\eqn{q_1+(1-q_0-q_1)\mu} and the probabilities of augmentation \eqn{q_0} and/or \eqn{q_1}.
If \code{type = "variance"}, the function returns \eqn{Var(Y|0<Y<1)} in case of no augmentation and
\eqn{(1-q_0-q_1)Var(Y|0<Y<1)+q_1^2+(1-q_0-q_1)\mu^2-(q_1+(1-q_0-q_1)\mu)^2} in case of augmentation.
If \code{cluster = TRUE}, for FB and FBB models, the function returns the cluster means (\eqn{\lambda_1} and \eqn{\lambda_2}) when \code{type = "response"} and the cluster variances when \code{type = "variance"}.

The option \code{type = "overdispersion"}  is available only for beta-binomial and flexible beta-binomial models and returns the fitted overdispersion.
}
\examples{
\dontrun{
data("Reading")
FB <- flexreg(accuracy.adj ~ iq, data=Reading, type="FB")
predict(FB, type="response", cluster=TRUE)
}

}
\references{
{
Ascari, R., Migliorati, S. (2021). A new regression model for overdispersed binomial data accounting for outliers and an excess of zeros. Statistics in Medicine, \bold{40}(17), 3895--3914. doi:10.1002/sim.9005 \cr
\cr
Di Brisco, A. M., Migliorati, S. (2020). A new mixed-effects mixture model for constrained longitudinal data. Statistics in Medicine, \bold{39}(2), 129--145. doi:10.1002/sim.8406 \cr
\cr
Migliorati, S., Di Brisco, A. M., Ongaro, A. (2018). A New Regression Model for Bounded Responses. Bayesian Analysis, \bold{13}(3), 845--872. doi:10.1214/17-BA1079 \cr
}
}
