% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_abc.R
\name{get_exit_type}
\alias{get_exit_type}
\title{Get exit type (from a vector \code{x} of FFT exit descriptions)}
\usage{
get_exit_type(x, verify = TRUE)
}
\arguments{
\item{x}{A vector of FFT exit descriptions.}

\item{verify}{A flag to turn verification on/off (as logical).
Default: \code{verify = TRUE}.}
}
\value{
A vector of \code{exit_types} (or an error).
}
\description{
\code{get_exit_type} checks and converts a vector \code{x}
of FFT exit descriptions into exits of an FFT
that correspond to the current options of
\code{exit_types} (as a global constant).
}
\details{
\code{get_exit_type} also verifies that the exit types conform to an FFT
(e.g., only the exits of the final node are bi-directional).
}
\examples{
get_exit_type(c(0, 1, .5))
get_exit_type(c(FALSE,   " True ",  2/4))
get_exit_type(c("noise", "signal", "final"))
get_exit_type(c("left",  "right",  "both"))

}
\seealso{
\code{\link{FFTrees}} for creating FFTs from and applying them to data.

Other utility functions: 
\code{\link{get_best_tree}()},
\code{\link{get_fft_df}()}
}
\concept{utility functions}
