% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.R
\name{get.best.model}
\alias{get.best.model}
\title{Extract the Best Model from MJMCMC or GMJMCMC Results}
\usage{
get.best.model(result, labels = FALSE)
}
\arguments{
\item{result}{An object of class \code{"mjmcmc"}, \code{"mjmcmc_parallel"}, \code{"gmjmcmc"}, or \code{"gmjmcmc_merged"},
containing the results from the corresponding model search algorithms.}

\item{labels}{Logical; if \code{TRUE}, uses labeled feature names when naming the model coefficients. Default is \code{FALSE}.}
}
\value{
A list containing the details of the best model:
\describe{
\item{\code{prob}}{A numeric value representing the model's probability.}
\item{\code{model}}{A logical vector indicating which features are included in the best model.}
\item{\code{crit}}{The criterion value used for model selection (e.g., marginal likelihood or posterior probability).}
\item{\code{alpha}}{The intercept parameter of the best model.}
\item{\code{coefs}}{A named numeric vector of model coefficients, including the intercept and selected features.}
}
}
\description{
This function retrieves the best model from the results of MJMCMC, MJMCMC parallel, GMJMCMC, or GMJMCMC merged runs
based on the maximum criterion value (\code{crit}). The returned list includes the model probability, selected features,
criterion value, intercept parameter, and named coefficients.
}
\details{
The function identifies the best model by selecting the one with the highest \code{crit} value. Selection logic depends on the class of the \code{result} object:
\describe{
\item{\code{"mjmcmc"}}{Selects the top model from a single MJMCMC run.}
\item{\code{"mjmcmc_parallel"}}{Identifies the best chain, then selects the best model from that chain.}
\item{\code{"gmjmcmc"}}{Selects the best population and model within that population.}
\item{\code{"gmjmcmc_merged"}}{Finds the best chain and population before extracting the top model.}
}
}
\examples{
result <- gmjmcmc(x = matrix(rnorm(600), 100),
y = matrix(rnorm(100), 100), 
P = 2, transforms = c("p0", "exp_dbl"))
get.best.model(result)

}
