% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtendedABSurvTDC.R
\name{DataPrep}
\alias{DataPrep}
\title{Data Preparation}
\usage{
DataPrep(data, t_int, max_lac)
}
\arguments{
\item{data}{Raw data sets}

\item{t_int}{No of days to be considered as single time interval (Default value: 90)}

\item{max_lac}{Maximum no of lactation to be considered for data preparation (Default value: Max Lactation)}
}
\value{
\itemize{
  \item wide_data - Processed data for ABCoxPH
}
}
\description{
Data preparation for ABCoxPH
}
\examples{
library("ExtendedABSurvTDC")
load(system.file("extdata", "data.RData", package = "ExtendedABSurvTDC"))
PropData<-DataPrep(data =as.data.frame(data_test))
}
\references{
\itemize{
\item J.D. Kalbfleisch and R.L. Prentice (1980). The statistical analysis of failure time data. John Wiley & Sons, Inc., New York, 1980.  <doi:10.1002/9781118032985>
\item J.P. Klein and  M L. Moeschberger (2003). Survival Analysis: Techniques for Censored and Truncated Data. Springer New York. <doi:10.1007/b97377>
}
}
