% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CharPart.R
\name{write_partitioned_alignments2}
\alias{write_partitioned_alignments2}
\title{Write alignment partitions as separate alignment files for various data types}
\usage{
write_partitioned_alignments2(
  x,
  cluster_df,
  partition_file,
  in_format = NULL,
  in_type = NULL,
  out_file,
  out_type = "standard"
)
}
\arguments{
\item{x}{concatenated alignment file in Nexus or Phyllip format read directly from local directory}

\item{cluster_df}{cluster partitions as outputted by \code{make.clusters}}

\item{partition_file}{name of text file with user provided partitions, with names and start&end positions}

\item{in_format}{Format of the input alignment file. One of "phylip", "interleaved", "sequential", "clustal", "fasta", or "nexus", or any unambiguous abbreviation. Passed to \code{phangorn::read.phyDat}.}

\item{in_type}{Type of input sequences. One of "DNA", "AA", "CODON" or "USER". Passed to \code{phangorn::read.phyDat}.}

\item{out_file}{Path to save the alignments. If \code{out_file = "example.nex"}, files will be saved as \code{"example_part1.nex"}, \code{"example_part2.nex"}, etc.}

\item{out_type}{Output format type. One of "dna" (default), "protein", "standard", or "continuous".}
}
\value{
No return value. This function is called for its side effect of writing alignment files to disk.
}
\description{
Write alignment partitions as separate alignment files for various data types
}
\examples{
# Load example phylogenetic data matrix
data("characters")

# Create distance matrix
Dmatrix <- get_gower_dist(characters)

# Find optimal partitioning scheme using PAM under k=3 partitions
cluster_df <- make_clusters(Dmatrix, k = 3)

# Write morphological partitions into multiple Nexus files
\dontrun{write_partitioned_alignments2(x = "characters.nex",
                             cluster_df = cluster_df,
                             out_file = "test", out_type = "standard")}

# Write to molecular partitions into multiple Phyllip files
\dontrun{write_partitioned_alignments2(x = "alignments.phy",
                             partition_file = "sorted_partitions_50genes.txt",
                             in_format = "phylip", in_type = "dna",
                             out_file = "test", out_type = "dna")}

}
\seealso{
\code{\link{write_partitioned_alignments}} for the older version supporting morphological data only.
}
