\name{EQUAL_verify_signature}
\alias{EQUAL_verify_signature}
\title{
Verify signature on a file
}
\description{
"Verifies the digital signature on a file using the public key generated by
\code{\link[=EQUAL_encrypt_generate_keys]{EQUAL_encrypt_generate_keys()}}
function, the signature created using
\code{\link[=EQUAL_insert_signature_file]{EQUAL_insert_signature_file()}}
function, and \pkg{openssl}."
}
\usage{
EQUAL_verify_signature(file_name, signature, key_name, public_key_folder)
}
\arguments{
\item{file_name}{Name of the file for which signature must be verified}
"\item{signature}{Signature created during the
\code{\link[=EQUAL_insert_signature_file]{EQUAL_insert_signature_file()}}
function}"
\item{key_name}{Name of the public key}
\item{public_key_folder}{Location of the public key}
}
\value{
logical indicating whether the signature is verified
}
\references{
\url{https://sites.google.com/view/equal-group/home}
}
\author{
Kurinchi Gurusamy
}
\note{
"This is part of a suite of functions required to allow encrypting and
decrypting whole files and encrypting and decrypting columns of data
programs to run. This is unlikely to be used as a stand alone function."
}
\seealso{
\code{\link[=EQUAL_encrypt_generate_keys]{EQUAL_encrypt_generate_keys()}}
\code{\link[openssl:signature_verify]{openssl::signature_verify()}}
}
\concept{EQUALencrypt}
\examples{
library(openssl)
# Encryption keys ####
test_folder <- tempfile(pattern = "folder_")
public_key_folder <- paste0(test_folder, "/public_key_folder")
private_key_folder <- paste0(test_folder, "/private_key_folder")
dir.create(test_folder)
dir.create(public_key_folder)
dir.create(private_key_folder)
encryption_keys <- EQUAL_encrypt_generate_keys(
  public_key_folder = public_key_folder,
  private_key_folder = private_key_folder,
  key_name = "encryption_key.txt")
# Data ####
data <- lapply(1:3, function(x) {
  mean = sample(1:100, 1, replace = FALSE)
  sd = sample(1:100, 1, replace = FALSE)
  rnorm(100, mean = mean, sd = sd)
})
data <- do.call(cbind.data.frame, data)
colnames(data) <- paste0("v", formatC(1:3, width = 6, flag = "0"))
test_file <- write.csv(data, paste0(tempdir(), "/test.csv"), row.names = FALSE,
na = "")
# Encrypt data ####
encrypted_data <- EQUAL_encrypt_file(file_name = paste0(tempdir(), "/test.csv"),
                                     public_key_folder = public_key_folder,
                                     key_name = "encryption_key.txt")
data_storage_folder <- paste0(test_folder, "/data_storage_folder")
dir.create(data_storage_folder)
saveRDS(encrypted_data, paste0(data_storage_folder, "/encrypted_file.RDS"))
# Insert signature ####
signature <- EQUAL_insert_signature_file(
file_name = paste0(data_storage_folder, "/encrypted_file.RDS"),
private_key_folder = private_key_folder,
key_name = "encryption_key.txt")
# Verify signature ####
results <- EQUAL_verify_signature(
file_name = paste0(data_storage_folder, "/encrypted_file.RDS"),
signature = signature, key_name = "encryption_key.txt",
public_key_folder = public_key_folder)
}
