% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimdupes.by.raster.R
\name{trimdupes.by.raster}
\alias{trimdupes.by.raster}
\title{Takes a set of points and a raster mask and returns a data frame trimmed so that only one point is returned per grid cell in the mask raster.}
\usage{
trimdupes.by.raster(points, mask)
}
\arguments{
\item{points}{A two column data frame with X and Y coordinates}

\item{mask}{A raster to use as a mask for drawing points}
}
\value{
A new data frame with one point per grid cell.
}
\description{
Takes a set of points and a raster mask and returns a data frame trimmed so that only one point is returned per grid cell in the mask raster.
}
\examples{
pts <- iberolacerta.clade$species$monticola$presence.points
trimdupes.by.raster(pts, euro.worldclim)
}
