% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizor.R
\name{normalizor}
\alias{normalizor}
\title{Feature Normalization for the pre-trained Neural Networks for Determining the Number of Factors}
\usage{
normalizor(features, model = "DNN")
}
\arguments{
\item{features}{A numeric matrix where each row represents an observation and each column represents a feature.}

\item{model}{A character string indicating the model type. Possible values are \code{"DNN"} (default) or \code{"LSTM"}.
It determines which precomputed scaler (means and standard deviations) will be used. The scaler is loaded via
\code{\link[EFAfactors]{load.scaler}} and should match the model used in subsequent analysis or prediction.}
}
\value{
A matrix of the same dimensions as \code{features}, where each feature has been normalized.
}
\description{
This function normalizes a matrix of features using precomputed means and standard deviations.
The function automatically runs \link[EFAfactors]{load.scaler} to read the standard deviations and means of the features,
which are organized into a \code{list} object named \code{\link[EFAfactors]{data.scaler.DNN}} or
\code{\link[EFAfactors]{data.scaler.LSTM}}. These means and standard deviations are computed from
the 10,000,000 datasets \code{\link[EFAfactors]{data.datasets.DNN}} for training the pre-trained Deep Neural Network (DNN) or
the 1,000,000 datasets \code{\link[EFAfactors]{data.datasets.LSTM}} for training the pre-trained Long Short Term Memory (LSTM) Network.
}
\details{
The function applies z-score normalization to each element in the \code{features} matrix. It uses
the \code{scaler} object, which is expected to contain precomputed means and standard deviations for each feature.
The normalized value for each element is computed as:
\deqn{z = \frac{x - \mu}{\sigma}}
where \eqn{x} is the original value, \eqn{\mu} is the mean, and \eqn{\sigma} is the standard deviation.
}
\seealso{
\code{\link[EFAfactors]{NN}}, \code{\link[EFAfactors]{load.scaler}},
\code{\link[EFAfactors]{data.datasets.DNN}}, \code{\link[EFAfactors]{data.scaler.DNN}},
\code{\link[EFAfactors]{data.datasets.LSTM}}, \code{\link[EFAfactors]{data.scaler.LSTM}}
}
