% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/telescope_match.R
\name{summary.tmatch}
\alias{summary.tmatch}
\title{Summarize telescope match objects}
\usage{
\method{summary}{tmatch}(object, ...)
}
\arguments{
\item{object}{an object of class \code{tmatch} -- results from a
call to \code{telescope_match}}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
Returns an object of \code{class} \code{summary.tmatch}.
Contains the following components
\itemize{
  \item \code{call}: matched call.
  \item \code{m_summary}: data.frame summarizes the matching
    ratios (\code{{ratio}}), number of units \code{n_1, n_0},
    and number of matched units (\code{matched_1, matched_0}) for
    each treatment/mediator (\code{term}).
  \item \code{K}: \code{K} data frame from the \code{object}
    telescope matching output.
  \item \code{L}: \code{L} vector from the \code{object}
    telescope matching output.
  \item \code{a_names}: character vector of the names of the
    treatment/mediator variables used in matching. 
  \item \code{estimates}: matrix of estimated ACDEs with and
    without bias correction and the estimated standard errors.
}
}
\description{
Summarize telescope match objects
}
\details{
\code{summary} method for \code{tmatch} objects returned by
\code{telescope_match}

Returns a summary data frame containing the estimate and
standard errors from the `telescope_match` object.
}
