% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treat.R
\name{set_treatment}
\alias{set_treatment}
\title{Specifiy a treatment variable for a controlled direct effect}
\usage{
set_treatment(
  object,
  treat,
  formula = NULL,
  treat_type = "categorical",
  eval_vals = NULL
)
}
\arguments{
\item{object}{A \code{cde_estimator} object that may or may have
previous treatment variables specified/}

\item{treat}{Name of the treatment variable (not quoted).}

\item{formula}{One-sided formula giving the covariates that are
pre-treatment to this treatment, but post-treatment to any previous
treatment. Unless overridden by the arguments to
\code{\link[=treat_model]{treat_model()}} or \code{\link[=outreg_model]{outreg_model()}},
this formula will be the specification used in the modeling of the
propensity scores or outcome regressions.}

\item{treat_type}{A string indicating the type of variable this is.
Takes either the values \code{"categorical"} or \code{"regression"} (the
latter is not yet implemented).
of}

\item{eval_vals}{A numeric vector of values of this variable to
evaluate the controlled direct effecct. If \code{NULL} (the default),
this will be set to all observed values of the variable.}
}
\value{
An updated \code{cde_estimator} with this information about the
treatment specified.
}
\description{
This function specifies a treatment variable in the sequence of
treatment variables that define the controlled direct effect of
interest.
}
\author{
Matthew Blackwell
}
