% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiffCorr.R
\name{comp.2.cc.fdr}
\alias{comp.2.cc.fdr}
\title{Export differential correlations between two conditions}
\usage{
comp.2.cc.fdr(
  output.file = "res.txt",
  data1,
  data2,
  method = "pearson",
  p.adjust.methods = "local",
  threshold = 0.05,
  save = FALSE
)
}
\arguments{
\item{output.file}{can specify file name of the results exported}

\item{data1}{data matrix under condition 1}

\item{data2}{data matrix under condition 2}

\item{method}{c("pearson", "spearman", "kendall")}

\item{p.adjust.methods}{c("local", holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none")}

\item{threshold}{a threshold of significance levels of differential correlation}

\item{save}{exports the results as a text if TRUE (default: FALSE)}
}
\value{
data.frame
}
\description{
Export differential correlations of comparison of two correlation matrices
}
\examples{
\dontrun{
data(AraMetRoots)
AraMetRoots[AraMetRoots==0] <- NA
AraMetRootsImp <- completeObs(pca(log2(AraMetRoots), nPcs=3, method="ppca"))
comp.2.cc.fdr(output.file="res.txt", AraMetRootsImp[,1:17], method="spearman",
              AraMetRootsImp[,18:37], threshold=0.05)
}
}
\references{
Fukushima, A. Gene (2013) 518, 209-214
}
\author{
Atsushi Fukushima
}
