#' Execute a Join Plan
#'
#' Takes a plan generated by `create_join_plan()` and executes it sequentially
#' to produce a final, merged data.table.
#'
#' @param join_plan A data.table created by `create_join_plan()`.
#' @param data_list A named list of the source data.tables.
#' @return A final, merged data.table.
#' @export
execute_join_plan <- function(join_plan, data_list) {

  exec_env <- new.env(parent = baseenv())
  
  for (name in names(data_list)) {
    assign(name, data_list[[name]], envir = exec_env)
  }
  
  for (i in 1:nrow(join_plan)) {
    code_to_run <- join_plan$code[i]
    message("Executing step ", i, ": ", code_to_run)
    
    eval(parse(text = code_to_run), envir = exec_env)
  }
  
  return(get("final_data", envir = exec_env))
}