% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_inventory.R
\name{ransac_circle_fit}
\alias{ransac_circle_fit}
\title{RANSAC circle fitting algorithm specially adapted for tree DBH estimation}
\usage{
ransac_circle_fit(
  data,
  n_iterations = 1000,
  distance_threshold = 0.01,
  min_inliers = 3
)
}
\arguments{
\item{data}{numeric matrix with 2 columns (X, Y) representing the point cloud}

\item{n_iterations}{integer maximum number of iterations}

\item{distance_threshold}{numeric maximum distance from a point to the circle to be considered an inlier}

\item{min_inliers}{integer minimum number of inliers to consider the circle as valid}
}
\value{
a list with the following elements:
circle: the center coordinates and radius of the circle
inliers: number of points within the circles dist threshold
angle_segs: number of populated 10deg angular segments of the circle using the distance_threshold
n_iter: number of iterations run
}
\description{
This function fits a circle to a set of points using the RANSAC algorithm it maximizes the points that are in the circle and the number of filled 36 degree angle segments
Therefore, this function searches for the most complete circle with the highest number of points represented.
}
