% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimating_BPBM.R
\name{Estimating_BPBM}
\alias{Estimating_BPBM}
\title{Estimating BPBM}
\usage{
Estimating_BPBM(
  especie,
  Tt,
  E,
  MatrizPBmodelo,
  nn.chain = 3,
  nn.burnin = 5000,
  nn.sample = 20000,
  nn.thin = 10,
  seed = NULL
)
}
\arguments{
\item{especie}{Matrix that contains at row i the bacterial taxa of bacteria i at all time points.}

\item{Tt}{Number of time points available.}

\item{E}{Number of bacteria in the dataset.}

\item{MatrizPBmodelo}{Matrix with the covariates of the model. In an example with two SPBal and three time points, the covariates are written in the following  order:
\tabular{rrr}{
1 \tab  1  \tab  1\cr
\eqn{SPBal_{1,t-1}} \tab  \eqn{SPBal_{1,t-2}} \tab   \eqn{SPBal_{1,t-3}} \cr
\eqn{SPBal_{2,t-1}} \tab  \eqn{SPBal_{2,t-2}} \tab   \eqn{SPBal_{2,t-3} }}}

\item{nn.chain}{the number of chains to use with the simulation. Default is 3, minimum2.}

\item{nn.burnin}{the number of burnin iterations. Default is 5000.}

\item{nn.sample}{the  number of iterations to take. Default: 20000. The markov chain will have ("sample"-"burnin")/"thin" iterations.}

\item{nn.thin}{the thinning interval to be used. Default: 10.}

\item{seed}{Number. Set a seed. Default \code{seed=NULL}.}
}
\value{
Returns a list with:

\itemize{
  \item List with:
  \itemize{
  \item R2jagsOutput:  R2jags object with the information of the estimation.
  \item SamplesAllChains:  Matrix. Matrix that has the iterations of all the Markov chains joined.
  }



  }
}
\description{
The estimation of the BPBM model is carried out using MCMC. To execute this function it is necessary to have the program Just Another Gibbs Sampler (JAGS) (Plummer, 2003) program installed.
}
\examples{

set.seed(314)
especie=t(gtools::rdirichlet(n=6, c(6,6,1,6,6)))
E=5
Tt=6
MatrizPBmodelo=rbind(c(1,1,1,1,1,1),c(-0.3,0.4,0.3,-0.7,-0.4,-0.6),c(0.3,0.5,-0.3,0.1,0.4,0.1))



Estimating_BPBM(especie,
               Tt,
               E,
               MatrizPBmodelo,
               nn.chain=3,
               nn.burnin=1000,
               nn.sample=2000,
               nn.thin=10,
               714)

}
\references{
\itemize{
\item Creus-Martí, I., Moya, A., Santonja, F. J. (2022). Bayesian hierarchical compositional models for analysing longitudinal abundance data from microbiome studies. Complexity, 2022.

\item Plummer, M. (2003, March). JAGS: A program for analysis of Bayesian graphical models using Gibbs sampling. In Proceedings of the 3rd international workshop on distributed statistical computing (Vol. 124, No. 125.10, pp. 1-10).
}
}
