% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.clusterBootstrap.R
\name{confint.clusterBootstrap}
\alias{confint.clusterBootstrap}
\title{Confidence intervals for clusterBootstrap objects}
\usage{
\method{confint}{clusterBootstrap}(
  object,
  parm = NULL,
  level = 0.95,
  type = c("percentile", "parametric", "bc"),
  ...
)
}
\arguments{
\item{object}{An object of class \code{"clusterBootstrap"}, as returned by \code{\link{clusterBootstrap}}.}

\item{parm}{A character vector of parameter names to compute confidence intervals for.
If \code{NULL} (default), intervals are computed for all parameters.}

\item{level}{Confidence level, e.g., \code{0.95} for a 95\% confidence interval.}

\item{type}{Type of confidence interval. One of \code{"percentile"}, \code{"parametric"}, or \code{"bc"}.
The default is \code{"percentile"}.}

\item{...}{Currently ignored. Included for method compatibility.}
}
\value{
A \code{data.frame} with one row per parameter and the following columns:
\describe{
  \item{term}{The name of the parameter.}
  \item{type}{The type of confidence interval used.}
  \item{conf.low}{The lower bound of the confidence interval.}
  \item{conf.high}{The upper bound of the confidence interval.}
}
}
\description{
Computes confidence intervals for estimates obtained via clustered bootstrap resampling.
Supported interval types are: percentile (default), normal approximation (parametric),
and bias-corrected (BC).
}
\details{
\itemize{
  \item \strong{Percentile}: uses the empirical quantiles of the bootstrap estimates.
  \item \strong{Parametric}: uses the bootstrap standard error and assumes normality.
  \item \strong{Bias-corrected (BC)}: adjusts for bias in the bootstrap distribution.
    Note: acceleration (BCa) is not implemented.
}
}
\examples{
\dontrun{
set.seed(2025)
n_school  <- 30
n_class   <- 8
n_student <- 15

demo <- expand.grid(school  = paste0("S", 1:n_school),
                    class   = paste0("C", 1:n_class),
                    student = paste0("P", 1:n_student)) |>
  mutate(score1 = rnorm(n()),
  score2 = rnorm(n())) |>
  arrange(school, class, student) |>
  slice(1:(n() - 3)) # slightly unbalanced data
bootFun2 <- function(d) lm(score1 ~ score2, data = d)$coef
clusterBootstrap(df       = demo, 
                 clusters = c("school", "class", "student"),
                 replace  = c(TRUE, FALSE, TRUE),
                 stat_fun = bootFun2,
                 B        = 1000) |>
  confint()
}
}
\seealso{
\code{\link{clusterBootstrap}}, \code{\link[stats]{confint}}
}
