/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.cohortdefinition.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ohdsi.circe.cohortdefinition.Criteria;
import org.ohdsi.circe.cohortdefinition.builders.BuilderOptions;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaColumn;

public abstract class CriteriaSqlBuilder<T extends Criteria> {
    public String getCriteriaSql(T criteria) {
        return this.getCriteriaSql(criteria, null);
    }

    public String getCriteriaSql(T criteria, BuilderOptions options) {
        List<CriteriaColumn> filteredColumns;
        String query = this.getQueryTemplate();
        query = this.embedCodesetClause(query, criteria);
        List<String> selectClauses = this.resolveSelectClauses(criteria);
        List<String> joinClauses = this.resolveJoinClauses(criteria);
        List<String> whereClauses = this.resolveWhereClauses(criteria);
        query = this.embedOrdinalExpression(query, criteria, whereClauses);
        query = this.embedSelectClauses(query, selectClauses);
        query = this.embedJoinClauses(query, joinClauses);
        query = this.embedWhereClauses(query, whereClauses);
        query = options != null ? ((filteredColumns = options.additionalColumns.stream().filter(column -> !this.getDefaultColumns().contains(column)).collect(Collectors.toList())).size() > 0 ? StringUtils.replace((String)query, (String)"@additionalColumns", (String)(", " + this.getAdditionalColumns(filteredColumns))) : StringUtils.replace((String)query, (String)"@additionalColumns", (String)"")) : StringUtils.replace((String)query, (String)"@additionalColumns", (String)"");
        return query;
    }

    protected abstract String getTableColumnForCriteriaColumn(CriteriaColumn var1);

    protected String getAdditionalColumns(List<CriteriaColumn> columns) {
        String cols = String.join((CharSequence)", ", columns.stream().map(column -> String.format("%s as %s", this.getTableColumnForCriteriaColumn((CriteriaColumn)((Object)column)), column.columnName())).collect(Collectors.toList()));
        return cols;
    }

    protected abstract Set<CriteriaColumn> getDefaultColumns();

    protected String embedSelectClauses(String query, List<String> selectClauses) {
        return StringUtils.replace((String)query, (String)"@selectClause", (String)StringUtils.join(selectClauses, (String)","));
    }

    protected String embedJoinClauses(String query, List<String> joinClauses) {
        return StringUtils.replace((String)query, (String)"@joinClause", (String)StringUtils.join(joinClauses, (String)"\n"));
    }

    protected String embedWhereClauses(String query, List<String> whereClauses) {
        String whereClause = "";
        if (whereClauses.size() > 0) {
            whereClause = "WHERE " + StringUtils.join(whereClauses, (String)"\nAND ");
        }
        return StringUtils.replace((String)query, (String)"@whereClause", (String)whereClause);
    }

    protected abstract String getQueryTemplate();

    protected abstract String embedCodesetClause(String var1, T var2);

    protected abstract String embedOrdinalExpression(String var1, T var2, List<String> var3);

    protected List<String> resolveSelectClauses(T criteria) {
        return new ArrayList<String>();
    }

    protected abstract List<String> resolveJoinClauses(T var1);

    protected List<String> resolveWhereClauses(T criteria) {
        ArrayList<String> whereClauses = new ArrayList<String>();
        if (((Criteria)criteria).dateAdjustment != null) {
            whereClauses.add("C.end_date >= C.start_date");
        }
        return whereClauses;
    }
}

