% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ovc_cpmrc.R
\name{catr_ovc_get_cpmrc}
\alias{catr_ovc_get_cpmrc}
\title{OVCCoordenadas: Geocode a cadastral reference}
\usage{
catr_ovc_get_cpmrc(
  rc,
  srs = 4326,
  province = NULL,
  municipality = NULL,
  verbose = FALSE
)
}
\arguments{
\item{rc}{The cadastral reference to be geocoded.}

\item{srs}{SRS/CRS to use on the query. To check the admitted values check
\link{catr_srs_values}, specifically the \code{ovc_service} column.}

\item{province, municipality}{Optional, used for narrowing the search.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}
}
\value{
A \code{\link[tibble:tibble]{tibble}}. See \strong{Details}
}
\description{
Implementation of the OVCCoordenadas service
\href{https://ovc.catastro.meh.es/ovcservweb/ovcswlocalizacionrc/ovccoordenadas.asmx?op=Consulta_CPMRC}{Consulta CPMRC}.

Return the coordinates for a specific cadastral reference.
}
\details{
When the API does not provide any result, the function returns a
\code{\link[tibble:tibble]{tibble}} with the input parameters only.

On a successful query, the function returns a \code{\link[tibble:tibble]{tibble}}
with one row by cadastral reference, including the following columns:
\itemize{
\item \code{xcoord}, \code{ycoord}: X and Y coordinates in the specified SRS.
\item \code{refcat}: Cadastral Reference.
\item \code{address}: Address as it is recorded on the Cadastre.
\item Rest of fields: Check the API Docs.
}
}
\examples{
\dontshow{if (tolower(Sys.info()[["sysname"]]) != "linux") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{

# using all the arguments
catr_ovc_get_cpmrc("13077A01800039",
  4230,
  province = "CIUDAD REAL",
  municipality = "SANTA CRUZ DE MUDELA"
)

# only the cadastral reference
catr_ovc_get_cpmrc("9872023VH5797S")
}
\dontshow{\}) # examplesIf}
}
\references{
\href{https://ovc.catastro.meh.es/ovcservweb/ovcswlocalizacionrc/ovccoordenadas.asmx?op=Consulta_CPMRC}{Consulta CPMRC}.
}
\seealso{
\link{catr_srs_values}, \code{vignette("ovcservice", package = "CatastRo")}

OVCCoordenadas API:
\code{\link{catr_ovc_get_rccoor}()},
\code{\link{catr_ovc_get_rccoor_distancia}()},
\code{\link{catr_srs_values}}

Other cadastral references: 
\code{\link{catr_ovc_get_rccoor}()},
\code{\link{catr_ovc_get_rccoor_distancia}()}
}
\concept{OVCCoordenadas}
\concept{cadastral references}
