% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{Brasil_males_df}
\alias{Brasil_males_df}
\title{Brazilian Male Demographics & Mortality (1980-1991)}
\format{
A data frame with 486 observations and 8 variables:
\describe{
  \item{cod}{Integer code identifying each federal state}
  \item{pop1}{Population count in 1980 (integer)}
  \item{pop2}{Population count in 1991 (integer)}
  \item{deaths}{Average number of deaths during the intercensal period (numeric)}
  \item{year1}{First census year (1980; integer)}
  \item{year2}{Second census year (1991; integer)}
  \item{age}{Abridged age group (integer values like 0, 1, 5, ..., 75; open age group at 80)}
  \item{sex}{Sex identifier; all values are "m" (character)}
}
}
\source{
Data taken from the DDM package version 1.0-0
}
\usage{
data(Brasil_males_df)
}
\description{
This dataset, Brasil_males_df, is a data frame containing population counts and mortality information
for males in Brazil, disaggregated by federal states and abridged age groups, for the years 1980 and 1991.
The dataset includes 486 observations and 8 variables. Population counts are reported for both years,
and deaths are given as average counts over the intercensal period. Age groups follow the pattern 0, 1, 5, ..., 75,
with an open age group at 80+. A total of 53 Brazilian states are represented.
}
\details{
The dataset name has been kept as 'Brasil_males_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
BrazilDataAPI package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
