% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_pa.R
\name{cv_bl}
\alias{cv_bl}
\title{Title}
\usage{
cv_bl(E, v_ord, N)
}
\arguments{
\item{E}{the observation matrix such that each of its row has a block structure correlation matrix Sigma to estimate up to a permutation of its columns and rows.}

\item{v_ord}{the absolute value of the upper  triangular part matrix \eqn{\Gamma} (including its diagonal) order in
increasing order}

\item{N}{number of replication in the "cross-validation"}
}
\value{
the number of non null values selected for the estimation of the covariance matrix
}
\description{
Title
}
\details{
In order to get the treshold one must do rev(v_ord)[cv_bl(E, v_ord, N=N)]
}
\examples{
n <- 30
q <- 100
Sigma <- Simu_Sigma(q = q, diag = FALSE, equal = TRUE)
Matrix::image(Sigma)
E <- matrix(rnorm(n * q), ncol = q) \%*\% chol(as.matrix(Sigma))
k <- 5
v_up <- est_up(E, k = k)
a_vup <- abs(v_up)
ord_vup <- order(a_vup)
v_ord <- a_vup[ord_vup]
N <- 10
nb_nn0 <- cv_bl(E, v_ord, N=N)
tresh <- rev(v_ord)[nb_nn0]
}
