% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioCircos.R
\name{BioCircosLineTrack}
\alias{BioCircosLineTrack}
\title{Create a track with lines to be added to a BioCircos tracklist}
\usage{
BioCircosLineTrack(trackname, chromosomes, positions, values,
  color = "#40B9D4", width = 2, maxRadius = 0.9, minRadius = 0.5,
  range = 0, ...)
}
\arguments{
\item{trackname}{The name of the new track.}

\item{chromosomes}{A vector containing the chromosomes on which each vertex is found.
Values should match the chromosome names given in the genome parameter of the BioCircos function.}

\item{positions}{A vector containing the coordinates on which each vertex are found.
Values should be inferior to the chromosome lengths given in the genome parameter of the BioCircos function.}

\item{values}{A vector of numerical values associated with each vertex, used to determine the 
radial coordinate of each vertex on the visualization.}

\item{color}{The color of the line in hexadecimal RGB format.}

\item{width}{The line width.}

\item{minRadius, maxRadius}{Where the track should begin and end, in proportion of the inner radius of the plot.}

\item{range}{Vector of values to be mapped to the minimum and maximum radii of the track.
Default to 0, mapping the minimal and maximal values input in the values parameter.}

\item{...}{Ignored}
}
\description{
Lines are defined by genomic coordinates and values of an ordered set of points,
 that will define the edges of the segments.
}
\examples{
BioCircos(BioCircosLineTrack('LnId', rep(1,30), 2e+6*(1:100), log(1:100)) 
  + BioCircosBackgroundTrack('BGId'))
}
