% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_param_fn.R
\name{plot_param_fn}
\alias{plot_param_fn}
\title{A function to plot the fitted parameters of stochastic mortality models, accompanied by credible intervals}
\usage{
plot_param_fn(result, pred_int = 0.95, legends = TRUE)
}
\arguments{
\item{result}{object of type either "fit_result" or "BayesMoFo".}

\item{pred_int}{A numeric value (between 0 and 1) specifying the credible level of uncertainty bands. Default is \code{pred_int=0.95} (\eqn{95\%} intervals).}

\item{legends}{A logical value to indicate if legends of the plots should be shown (default) or suppressed (e.g. to aid visibility).}
}
\value{
A plot illustrating the median fitted and forecast parameters, accompanied by credible intervals.
}
\description{
Plot the fitted parameters, accompanied by credible intervals (user-specified level), using posterior samples stored in "fit_result" object.
}
\examples{
\donttest{
#load and prepare data
data("dxt_array_product");data("Ext_array_product")
death<-preparedata_fn(dxt_array_product,strat_name = c("ACI","DB","SCI"),ages=35:65)
expo<-preparedata_fn(Ext_array_product,strat_name = c("ACI","DB","SCI"),ages=35:65)

#fit any mortality model
runBayesMoFo_result<-runBayesMoFo(death=death,expo=expo,n_iter=1000,models="APCI",
  family="poisson",forecast=TRUE)

#default plot
plot_param_fn(runBayesMoFo_result)

#with 80\% credible intervals 
plot_param_fn(runBayesMoFo_result,pred_int=0.8)
}
}
\concept{credible intervals}
\concept{fitted parameters}
\concept{forecast parameters}
\keyword{graphics}
\keyword{plots}
\keyword{visualization}
