% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DefineWHAM.R
\name{DefineWHAM}
\alias{DefineWHAM}
\title{Read a WHAM file and make a WHAM list}
\usage{
DefineWHAM(WHAMVer = "V", WHAMFile = NA)
}
\arguments{
\item{WHAMVer}{a character string specifying the WHAM version to use, must be
one of `"V"` (default), `"VI"`, or `"VII"`. Ignored if `WHAMFile` is not
`NA`.}

\item{WHAMFile}{(optional) a character string specifying the file path of a
WHAM parameter file}
}
\value{
A WHAM list in the format of `BlankWHAM()`.
}
\description{
A WHAM file is a text file (typically with the file extension
  ".wdat") that has all of the information necessary for defining organic
  matter binding, according to the Windemere Humic Aqueous Model (WHAM). Only
  constants relating directly to organic matter binding are in this object
  and file (i.e., nothing related to inorganic binding). This is the
  information needed by the `ExpandWHAM()` function and to do organic matter
  binding in the `CHESS` subroutine.
}
