% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_plot_coord.R
\name{check_plot_coord}
\alias{check_plot_coord}
\title{Check coordinates of plot corners and trees}
\usage{
check_plot_coord(
  corner_data,
  proj_coord = NULL,
  longlat = NULL,
  rel_coord,
  trust_GPS_corners,
  draw_plot = TRUE,
  tree_data = NULL,
  tree_coords = NULL,
  max_dist = 10,
  rm_outliers = TRUE,
  plot_ID = NULL,
  tree_plot_ID = NULL,
  ref_raster = NULL,
  prop_tree = NULL,
  ask = T
)
}
\arguments{
\item{corner_data}{A data frame, data frame extension, containing the plot corner coordinates.}

\item{proj_coord}{(optional, if longlat is not provided) A character vector of length 2, specifying the column names (resp. x, y) of the corner projected coordinates.}

\item{longlat}{(optional, if proj_coord is not provided) A character vector of length 2 specifying the column names of the corner geographic coordinates (long,lat).}

\item{rel_coord}{A character vector of length 2 specifying the column names (resp. x, y) of the corner relative coordinates (that of the field, ie, the local ones).}

\item{trust_GPS_corners}{A logical indicating whether or not you trust the GPS coordinates of the plot's corners. See details.}

\item{draw_plot}{A logical indicating if the plot design should be displayed and returned.}

\item{tree_data}{A data frame, data frame extension, containing the relative coordinates (field/local coordinates) of the trees and optional other tree metrics.}

\item{tree_coords}{A character vector specifying the column names of the tree relative coordinates.}

\item{max_dist}{If dealing with repeated measurements of each corner : the maximum distance (in meters) above which GPS measurements should be considered outliers (default 15 m).}

\item{rm_outliers}{If TRUE and dealing with repeated measurements of each corner, then outliers are removed from the coordinate calculation of the referenced corners.}

\item{plot_ID}{If dealing with multiple plots : a character indicating the variable name for corner plot IDs in corner_data.}

\item{tree_plot_ID}{If dealing with multiple plots : a character indicating the variable name for tree plot IDs in tree_data.}

\item{ref_raster}{A SpatRaster object from terra package, typically a chm raster created from LiDAR data.}

\item{prop_tree}{The column name variable of tree_data for which the tree visualization will be proportional.}

\item{ask}{If TRUE and dealing with multiple plots, then prompt user before displaying each plot.}
}
\value{
Returns a list including :
\itemize{
\item \code{corner_coord}: a data frame containing the projected coordinates (x_proj and y_proj) and the relative coordinates (x_rel and y_rel) of the 4 corners of the plot
\item \code{polygon}: a sf object containing plot's polygon(s)
\item \code{tree_data}: if \code{tree_data} is provided in the arguments of the function, a data frame corresponding to tree_data for which the projected coordinates of the trees (x_proj and y_proj) are added, and also a variable telling if the trees are inside the plot (is_in_plot). The name of the relative tree coordinates are also standardised and renamed to (x_rel and y_rel).
\item \code{outliers}: a data frame containing the projected coordinates and the row number of GPS measurements considered outliers
\item \code{plot_design}: if \code{draw_plot} is TRUE, a ggplot object corresponding to the design of the plot
\item \code{UTM_code}: if \code{longlat} is provided, a data.frame containing the UTM code of the corner GPS coordinates for each plot
}
}
\description{
Quality check of plot corner and tree coordinates.
}
\details{
If trust_GPS_corners is TRUE, corner coordinates in the projected coordinate system are averaging by corner (if multiple measures) and outlier corners are identified sequentially using these averages and the max_dist argument. Then, projected coordinates of the trees are calculated from the local coordinates using a bilinear interpolation that follows the correspondence of the corners between these two coordinate systems. Be aware that this projection only works if the plot, in the relative coordinates system, is rectangular (ie, has 4 right angles).

If trust_GPS_corners is FALSE, corner coordinates in the projected coordinate system are calculated by a procrust analysis that preserves the shape and dimensions of the plot in the local coordinate system. Outlier corners are also identified sequentially and projected coordinates of the trees are calculated by applying the resulting procrust analysis.

If longlat is provided instead of proj_coord, the function will first convert the long/lat coordinates into UTM coordinates. An error may result if the parcel is located right between two UTM zones. In this case, the user has to convert himself his long/lat coordinates into any projected coordinates which have the same dimension than his local coordinates (in meters most of the time).

If longlat and proj_coord are provided, only longitude/latitude coordinates will be considered.

When ref_raster is provided, this raster is cropped for every plot contained in corner_data.
}
\examples{
# One plot with repeated measurements of each corner
data("NouraguesPlot201")
check_plot201 <- check_plot_coord(
  corner_data = NouraguesPlot201,
  proj_coord = c("Xutm","Yutm"), rel_coord = c("Xfield","Yfield"),
  trust_GPS_corners = TRUE, draw_plot = FALSE)
check_plot201$corner_coord
\donttest{
  check_plot201$plot_design
}

# 4 plots with one measurement of each corner
data("NouraguesCoords")
check_plots <- check_plot_coord(
  corner_data = NouraguesCoords,
  proj_coord = c("Xutm","Yutm"), rel_coord = c("Xfield","Yfield"),
  trust_GPS_corners = TRUE, plot_ID = "Plot", draw_plot = FALSE)
check_plots$corner_coord
\donttest{
  check_plots$plot_design
}

# Displaying the associated CHM raster and representing trees proportionally to their diameter
plot_204_coords <- NouraguesCoords[NouraguesCoords$Plot==204,]
data("NouraguesTrees")
plot_204_trees <- NouraguesTrees[NouraguesTrees$Plot == 204, ]
nouragues_raster <- terra::rast(
  system.file("extdata", "NouraguesRaster.tif",
              package = "BIOMASS", mustWork = TRUE)
  )
check_plot_204 <- check_plot_coord(
 corner_data = plot_204_coords,
 proj_coord = c("Xutm","Yutm"), rel_coord = c("Xfield","Yfield"),
 trust_GPS_corners = TRUE, draw_plot = FALSE,
 tree_data = plot_204_trees, tree_coords = c("Xfield","Yfield"),
 ref_raster = nouragues_raster, prop_tree = "D"
)
\donttest{
  check_plot_204$plot_design
}
}
\author{
Arthur PERE, Maxime REJOU-MECHAIN, Arthur BAILLY

Arthur BAILLY, Arthur PERE, Maxime REJOU-MECHAIN
}
