% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/read.R
\docType{methods}
\name{read_chronomodel}
\alias{read_chronomodel}
\alias{read_chronomodel-method}
\alias{read_chronomodel_events}
\alias{read_chronomodel_events-method}
\alias{read_chronomodel_phases}
\alias{read_chronomodel_phases-method}
\alias{read_chronomodel_events,character-method}
\alias{read_chronomodel_phases,character-method}
\title{Read ChronoModel Output}
\usage{
read_chronomodel_events(file, ...)

read_chronomodel_phases(file, ...)

\S4method{read_chronomodel_events}{character}(file, calendar = CE(), sep = ",", dec = ".")

\S4method{read_chronomodel_phases}{character}(file, calendar = CE(), sep = ",", dec = ".")
}
\arguments{
\item{file}{A \code{\link{character}} string giving the name of the CSV file which the
data are to be read from.}

\item{...}{Currently not used.}

\item{calendar}{A \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the calendar
(see \code{\link[aion:calendar]{aion::calendar()}}). It should be \code{\link[aion:gregorian]{aion::CE()}} unless you change the
default settings in 'ChronoModel'.}

\item{sep}{A \code{\link{character}} string specifying the field separator character
(see \code{\link[utils:read.table]{utils::read.table()}}).}

\item{dec}{A \code{\link{character}} string specifying the character used in the file
for decimal points (see \code{\link[utils:read.table]{utils::read.table()}}).}
}
\value{
An \code{\linkS4class{EventsMCMC}} or a \code{\linkS4class{PhasesMCMC}} object.
}
\description{
Reads MCMC output.
}
\examples{
if (requireNamespace("ArchaeoData", quietly = TRUE)) {
  ## Construct the paths to the data
  path <- file.path("chronomodel", "ksarakil")
  path_events <- system.file(path, "Chain_all_Events.csv", package = "ArchaeoData")
  path_phases <- system.file(path, "Chain_all_Phases.csv", package = "ArchaeoData")

  ## Import ChronoModel events
  (chrono_events <- read_chronomodel_events(path_events))

  ## Import ChronoModel phases
  (chrono_phases <- read_chronomodel_phases(path_phases))
}
}
\references{
Lanos, Ph., Philippe, A. & Dufresne, Ph. (2015). Chronomodel:
Chronological Modeling of Archaeological Data using Bayesian Statistics.
URL: \url{https://chronomodel.com/}.
}
\seealso{
\code{\link[utils:read.table]{utils::read.table()}}

Other read methods: 
\code{\link{as_coda}()},
\code{\link{as_events}()},
\code{\link{as_phases}()},
\code{\link{check}},
\code{\link{read_bcal}()},
\code{\link{read_oxcal}()}
}
\author{
T. S. Dye, N. Frerebeau
}
\concept{read methods}
