% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format-chromosome-utility.R
\name{format.chromosome.notation}
\alias{format.chromosome.notation}
\title{Format chromosome names}
\usage{
\method{format}{chromosome.notation}(chromosome, chr.prefix, numeric.sex.chr)
}
\arguments{
\item{chromosome}{A character vector of chromosome names.}

\item{chr.prefix}{A logical indicating whether the 'chr' prefix should be used when formatting chromosome name.}

\item{numeric.sex.chr}{A logical indicating whether the sex chromosomes should be formatted numerically, as opposed to alphabetically.}
}
\value{
A character vector of chromosome names formatted according to user specifications.
}
\description{
Format chromosome names according to user specifications.
}
\examples{
numeric.chr <- c(1,2,23,24);
chr.with.prefix <- c('chr1', 'chr2', 'chrX', 'chrY');
format.chromosome.notation(numeric.chr, chr.prefix = TRUE, numeric.sex.chr = FALSE);
format.chromosome.notation(chr.with.prefix, chr.prefix = FALSE, numeric.sex.chr = TRUE);
}
