% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-Pop.R
\docType{class}
\name{Pop-class}
\alias{Pop-class}
\alias{[,Pop-method}
\alias{c,Pop-method}
\alias{show,Pop-method}
\alias{length,Pop-method}
\title{Population}
\usage{
\S4method{[}{Pop}(x, i)

\S4method{c}{Pop}(x, ...)

\S4method{show}{Pop}(object)

\S4method{length}{Pop}(x)
}
\arguments{
\item{x}{a 'Pop' object}

\item{i}{index of individuals}

\item{...}{additional 'Pop' objects}

\item{object}{a 'Pop' object}
}
\description{
Extends \code{\link{RawPop-class}} to add sex, genetic values,
phenotypes, and pedigrees.
}
\section{Methods (by generic)}{
\itemize{
\item \code{[}: Extract Pop by index or id

\item \code{c(Pop)}: Combine multiple Pops

\item \code{show(Pop)}: Show population summary

\item \code{length(Pop)}: Number of individuals in Pop (the same as nInd())

}}
\section{Slots}{

\describe{
\item{\code{id}}{an individual's identifier}

\item{\code{iid}}{an individual's internal identifier}

\item{\code{mother}}{the identifier of the individual's mother}

\item{\code{father}}{the identifier of the individual's father}

\item{\code{sex}}{sex of individuals: "M" for males, "F" for females,
and "H" for hermaphrodites}

\item{\code{nTraits}}{number of traits}

\item{\code{gv}}{matrix of genetic values. When using GxE traits,
gv reflects gv when p=0.5. Dimensions are nInd by nTraits.}

\item{\code{pheno}}{matrix of phenotypic values. Dimensions are
nInd by nTraits.}

\item{\code{ebv}}{matrix of estimated breeding values. Dimensions
are nInd rows and a variable number of columns.}

\item{\code{gxe}}{list containing GxE slopes for GxE traits}

\item{\code{fixEff}}{a fixed effect relating to the phenotype.
Used by genomic selection models but otherwise ignored.}

\item{\code{misc}}{a list whose elements correspond to additional miscellaneous
nodes with the items for individuals in the population (see example in
\code{\link{newPop}}) - we support vectors and matrices or objects that
have a generic length and subset method.
This list is normally empty and exists solely as an
open slot available for uses to store extra information about
individuals.}

\item{\code{miscPop}}{a list of any length containing optional meta data for the
population (see example in \code{\link{newPop}}).
This list is empty unless information is supplied by the user.
Note that the list is emptied every time the population is subsetted or
combined because the meta data for old population might not be valid anymore.}
}}

\seealso{
\code{\link{newPop}}, \code{\link{newEmptyPop}}, \code{\link{resetPop}}
}
