% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AdIsMF.R
\name{LNLM}
\alias{LNLM}
\title{Langmuir Nonlinear Model}
\usage{
LNLM (ce, qe)
}
\arguments{
\item{ce}{Equilibrium concentration of the adsorbate in the solution}

\item{qe}{Amount adsorbed}
}
\value{
\itemize{
  \item Langmuir Isotherm Nonlinear Model: Model summary
  \item correlation (ce, qe): Correlation between ce and qe
  \item b: Adsorption maxima
  \item k: Langmuir adsorption constant related to bonding energy
  \item AIC: Akaike information criterion
  \item AICc: Corrected Akaike information criterion
  \item BIC: Bayesian information criterion
  \item RMSE: Root Mean Squared Error
  \item MSE: Mean Squared Error
  \item MAE: Mean Absolute Error
  \item MAPE: Mean Absolute Percentage Error
  \item MPSD: Marquardt’s Percent Standard Deviation
  \item Chi.square: Chi-square value
}
}
\description{
This model will fit the adsorption data to the nonlinear form of the Langmuir equation and will give the estimates of the Langmuir parameters, namely "b" and "k" while evaluating the performance efficiency of the nonlinear model of Langmuir through several error functions.
}
\examples{
ce <- c(0.025, 0.04, 0.055, 0.099, 0.139, 0.402, 1.999, 11.336)
qe <- c(17.21, 35.42, 51.238, 72.659, 89.268, 182.21, 345.29, 634.231)
m.fit <- LNLM (ce, qe)
}
\references{
\itemize{
\item Langmuir, I. (1918). The adsorption of gases on plane surfaces of glass, mica and platinum. Journal of the American Chemical society, 40(9), 1361-1403.
\item Datta, S. P., Bhadoria, P. B. S., & Kar, S. (1998). Availability of extractable boron in some acid soils, West Bengal, India. Communications in soil science and plant analysis, 29(15-16), 2285-2306.
\item Roy, A., Manjaiah, K. M., Datta, S. P., Rakshit, D., Barman, M., Ray, P., Golui, D., Raza, M. B., Tigga, P., Mondal, S., Vishwanath, Meena, S., & Meena, P. (2025). Effect of Low-Molecular-Weight Organic Acids and Silicon on Arsenic Adsorption and Desorption in a Paddy Soil of Bengal Delta Plain: Insights from Thermodynamics and Equilibrium Modeling. Water, Air, & Soil Pollution, 236(6), 344.
\item Raza, M. B., Datta, S. P., Golui, D., Barman, M., Ray, P., Upadhyay, D., Mishra, R., Roy, A., & Dash, A. K. (2025). Enhancing soil arsenic immobilization with organic and inorganic amendments: Insights from sorption–desorption study. Environmental Monitoring and Assessment, 197(1), 76.
}
}
