% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vorob_optim_parallel2_gpc.R
\name{vorob_optim_parallel2_gpc}
\alias{vorob_optim_parallel2_gpc}
\title{Parallel Vorob'ev criterion}
\usage{
vorob_optim_parallel2_gpc(
  x,
  other.points,
  integration.points,
  integration.weights = NULL,
  intpoints.oldmean,
  intpoints.oldsd,
  precalc.data,
  object,
  new.noise.var = NULL,
  batchsize,
  alpha,
  current.vorob,
  seed = NULL
)
}
\arguments{
\item{x}{input vector of size d at which one wants to evaluate the criterion.}

\item{other.points}{vector giving the other \code{batchsize-1} points at which one wants to evaluate the criterion.}

\item{integration.points}{p*d matrix of points for numerical integration in the design space.}

\item{integration.weights}{vector of size p corresponding to the weights of these integration points.}

\item{intpoints.oldmean}{vector of size p corresponding to the latent GP mean at the integration points before adding \code{x} to the design of experiments.}

\item{intpoints.oldsd}{vector of size p corresponding to the latent GP standard deviation at the integration points before adding \code{x} to the design of experiments.}

\item{precalc.data}{list containing precalculated data. This list can be generated using the \code{precomputeUpdateData} function.}

\item{object}{object of class \code{\link[GPCsign]{gpcm}}.}

\item{new.noise.var}{optional scalar value of the noise variance of the new observations.}

\item{batchsize}{number of points to sample simultaneously. The sampling criterion will return batchsize points at a time for sampling.}

\item{alpha}{a scalar representing the Vorob'ev threshold.}

\item{current.vorob}{current value of the vorob criterion (before adding new observations).}

\item{seed}{to fix the seed.}
}
\value{
Parallel Vorob'ev value
}
\description{
Evaluation of the Vorob'ev criterion for candidate points \code{x}, assuming that some other points are also going to be evaluated. To be used in optimization routines, like in \code{\link{max_vorob_parallel_gpc}}. To avoid numerical instabilities, the new points are evaluated only if they are not too close to an existing observation, or if there is some observation noise. The criterion is the integral of the posterior Vorob'ev uncertainty.
}
\references{
Menz, M., Munoz-Zuniga, M., Sinoquet, D. Estimation of simulation failure set with active learning based on Gaussian Process classifiers and random set theory (2023). \url{https://hal.science/hal-03848238}.

Chevalier, C. Fast uncertainty reduction strategies relying on Gaussian process models PhD Thesis. University of Bern (2013).

Bachoc, F., Helbert, C. & Picheny, V. Gaussian process optimization with failures: classification and convergence proof. \emph{J Glob Optim} \bold{78}, 483–506 (2020). \doi{10.1007/s10898-020-00920-0}.
}
\seealso{
\code{\link[=max_vorob_parallel_gpc]{max_vorob_parallel_gpc()}}
}
\author{
Morgane MENZ, Delphine SINOQUET, Miguel MUNOZ-ZUNIGA. Contributors: Naoual SERRAJI.
}
