% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approximate_price.R
\name{approximate_price_gpt}
\alias{approximate_price_gpt}
\title{Approximate price estimation for title and abstract screening using OpenAI's GPT API models}
\usage{
approximate_price_gpt(
  data,
  prompt,
  studyid,
  title,
  abstract,
  model = "gpt-4o-mini",
  reps = 1,
  top_p = 1,
  token_word_ratio = 1.6
)
}
\arguments{
\item{data}{Dataset containing the titles and abstracts.}

\item{prompt}{Prompt(s) to be added before the title and abstract.}

\item{studyid}{Unique Study ID. If missing, this is generated
automatically.}

\item{title}{Name of the variable containing the title information.}

\item{abstract}{Name of variable containing the abstract information.}

\item{model}{Character string with the name of the completion model. Can take
multiple models, including gpt-4 models. Default = \code{"gpt-4o-mini"}.
Find available model at
\url{https://platform.openai.com/docs/models/model-endpoint-compatibility}.}

\item{reps}{Numerical value indicating the number of times the same
question should be sent to the GPT server. This can be useful to test consistency
between answers. Default is \code{1} but when using gpt-3.5-turbo or gpt-4o-mini models, we recommend setting this
value to \code{10}.}

\item{top_p}{'An alternative to sampling with temperature, called nucleus sampling,
where the model considers the results of the tokens with top_p probability mass.
So 0.1 means only the tokens comprising the top 10\% probability mass are considered.
We generally recommend altering this or temperature but not both.' (OPEN-AI). Default is 1.
Find documentation at
\url{https://platform.openai.com/docs/api-reference/chat/create#chat/create-top_p}.}

\item{token_word_ratio}{The multiplier used to approximate the number of tokens per word.
Default is \code{1.6} which we empirically have found to be the average number of tokens per word.}
}
\value{
An object of class \code{"gpt_price"}. The object is a list containing the following
components:
\item{price}{numerical value indicating the total approximate price (in USD) of the screening across all gpt-models expected to be used for the screening.}
\item{price_data}{dataset with prices across all gpt models expected to be used for screening.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}\if{html}{\out{<br>}}
\if{html}{\out{<br>}}
This function supports the approximation of the price of title and abstract
screenings when using OpenAI's GPT API models. The function only provide approximately accurate price
estimates. When detailed descriptions are used,
this will increase the completion tokens with an unknown amount.
}
\examples{
prompt <- "This is a prompt"

app_price <- approximate_price_gpt(
  data = filges2015_dat[1:2,],
  prompt = prompt,
  studyid = studyid,
  title = title,
  abstract = abstract,
  model = c("gpt-4o-mini", "gpt-4"),
  reps = c(10, 1)
)

app_price
app_price$price_dollar
app_price$price_data
}
