% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_ahm.R
\name{cv.ahm}
\alias{cv.ahm}
\title{This is one of the main functions. It perform the cross validation on ahm models to select the optimal setting of hyper parameter h}
\usage{
cv.ahm(y, x, powerh_path = NULL, metric = c("mse", "AICc"), num_major = 3,
  dist_minor = c(2, 2, 1), type = "weak", alpha = 0, lambda_seq = seq(0,
  5, 0.01), nfolds = NULL, mapping_type = c("power"), rep_gcv = 100)
}
\arguments{
\item{y}{numeric vector}

\item{x}{data.frame Note the column names of the x should be in the order of major components, minor components, and no interactions between major or minor components are needed.}

\item{powerh_path}{if NULL, then the default is the vector: round(seq(0.001,2,length.out =15),3)}

\item{metric}{"mse" or "AICc" the metric used in cross validtion where the minimum is selected as the optimal}

\item{num_major}{number of major components}

\item{dist_minor}{the allocation of number of minor components nested under major components}

\item{type}{heredity type, weak heredity is the current support type}

\item{alpha}{0 is for the ridge in glmnet https://web.stanford.edu/~hastie/glmnet/glmnet_alpha.html}

\item{lambda_seq}{a numeric vector for the options of lambda used in ridge regression for estimating the initials}

\item{nfolds}{used in cv.glmnet for initial value of parameters in the non-negative garrote method}

\item{mapping_type}{the form of the coefficient function of major components in front of corresponding minor terms. Currently only support "power"}

\item{rep_gcv}{the number of choices of tuning parameter used in the GCV selection}
}
\value{
Return a list
}
\description{
This is one of the main functions. It perform the cross validation on ahm models to select the optimal setting of hyper parameter h
}
\examples{
\donttest{
data("pringles_fat")
data_fat = pringles_fat
h_tmp = 1.3
x = data_fat[,c("c1","c2","c3","x11","x12","x21","x22")]
y = data_fat[,1]
powerh_path = round(seq(0.001,2,length.out =15),3)
num_major = 3; dist_minor = c(2,2,1)
res = cv.ahm (y, x, powerh_path=powerh_path, metric = "mse", num_major, dist_minor, type = "weak"
, alpha=0, lambda_seq=seq(0,5,0.01), nfolds=NULL, mapping_type = c("power"), rep_gcv=100)
object = res$metric_mse
}
}
