% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist.R
\name{get_col}
\alias{get_col}
\title{Get a Column from the Yahoo Finance API}
\usage{
get_col(data, col)
}
\arguments{
\item{data}{data frame or list. Data that contains an \code{index} column and
the requested column created using the \code{\link{get_data}} function.}

\item{col}{string. Column name to get (i.e., "open", "high", "low", "close", "adjclose", "volume").}
}
\value{
A data frame with rows as the \code{index} and columns as the symbols.
}
\description{
A function to get a column from the Yahoo Finance API for symbols using a date 
range and interval.
}
\examples{
\dontrun{
data <- get_data(c("AAPL", "MSFT"))

adj <- get_col(data, "adjclose")
}
}
