% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_sample3d.R
\name{curve_sample3d}
\alias{curve_sample3d}
\title{Sample a 3D parametric curve}
\usage{
curve_sample3d(X, Y, Z, a, b, n_samples = 400)
}
\arguments{
\item{X, Y, Z}{Functions of one variable \code{t}, e.g. \code{function(t) 2 * cos(t)}.}

\item{a, b}{Numeric parameter limits for \code{t}.}

\item{n_samples}{Integer. Number of sample points along the curve.}
}
\value{
A tibble with columns \code{t}, \code{x}, \code{y}, \code{z},
where \code{x = X(t)}, \code{y = Y(t)}, \code{z = Z(t)}.
}
\description{
Generates a tibble with columns \code{t, x, y, z} by evaluating
the parametric curve \eqn{(X(t), Y(t), Z(t))} on the interval
\eqn{[a, b]} at a given number of sample points.
}
\examples{
X <- function(t) 2 * cos(t)
Y <- function(t) 3 * sin(t)
Z <- function(t) t / 5
curve_sample3d(X, Y, Z, 0, 2 * pi, n_samples = 100)

}
\seealso{
\code{\link[=plot_curve3d]{plot_curve3d()}}, \code{\link[=arc_length3d]{arc_length3d()}}
}
