% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server_api.R
\name{tbs_custom_sql_graphql}
\alias{tbs_custom_sql_graphql}
\title{Custom SQL (Metadata API) for a published item}
\usage{
tbs_custom_sql_graphql(
  content_id,
  base_url = Sys.getenv("TABLEAU_BASE_URL"),
  site = Sys.getenv("TABLEAU_SITE"),
  token = Sys.getenv("TABLEAU_PAT")
)
}
\arguments{
\item{content_id}{Character. Workbook or datasource ID (GUID).}

\item{base_url}{Character. Server/Cloud base URL (e.g., "https://...").}

\item{site}{Character. Site contentUrl ("" for default site).}

\item{token}{Character. REST credentials token.}
}
\value{
A tibble with columns such as \code{custom_sql_name}, \code{custom_sql_query},
\code{database}, \code{schema}. Zero rows if none.
}
\description{
Queries the Metadata (GraphQL) API for Custom SQL tables in the content graph.
}
\examples{
\dontshow{if (all(nzchar(Sys.getenv(c("TABLEAU_BASE_URL","TABLEAU_SITE","TABLEAU_PAT"))))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
tbs_custom_sql_graphql("abc-123")
\dontshow{\}) # examplesIf}
}
