% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsforecast_1.2.1.R
\name{tsboxplot}
\alias{tsboxplot}
\title{Box Plots}
\usage{
tsboxplot(
  x,
  title = NULL,
  x.name = NULL,
  x.col = "darkgrey",
  mean.col = "steelblue4"
)
}
\arguments{
\item{x}{a univariate time series object or a numeric vector or matrix.}

\item{title}{title of the box plot}

\item{x.name}{name of the series. If omitted here, the series name found by \code{tsname()} will be taken over here. If \code{tsname()} is \code{NULL}, the variable name will be used instead. Default is \code{NULL}.}

\item{x.col}{line colour of the box plot.}

\item{mean.col}{colour of the dot indicating the series mean.}
}
\value{
A boxplot of \code{x} will be displayed with no further values or objects returned.
}
\description{
Produce box-and-whisker plot of a given univariate time series.
}
\details{
Since \code{x} is a univariate time series, no parallel box plots can be plotted here.

Missing values are ignored when forming boxplots.
}
\examples{
tsboxplot(airport$Travellers)
}
\references{
Chambers, J. M., Cleveland, W. S., Kleiner, B., & Tukey, P. A. (1983). Graphical Methods for Data Analysis. Wadsworth & Brooks/Cole.
}
\author{
Ka Yui Karl Wu
}
