% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zph_phregr.R
\name{zph_phregr}
\alias{zph_phregr}
\title{Assess Proportional Hazards Assumption Based on Scaled
Schoenfeld Residuals}
\usage{
zph_phregr(object, transform = "km")
}
\arguments{
\item{object}{The output from the \code{phregr} call.}

\item{transform}{A character string indicating how survival times
should be transformed before the test is performed. Supported values
include "identity", "log", "rank", and "km" (default).}
}
\value{
A list with the following components:
\itemize{
\item \code{table} A matrix with one row for each parameter and a final
row for the global test. The columns contain the score test
for adding the time-dependent term, the degrees of freedom,
and the two-sided p-value.
\item \code{x} The transformed time values.
\item \code{time} The original (untransformed) event times, with tied event
times repeated.
\item \code{strata} The stratum index for each event.
\item \code{y} The matrix of scaled Schoenfeld residuals, with one column
for each parameter and one row for each event. Column names correspond
to the parameter names.
\item \code{var} An approximate covariance matrix of the scaled Schoenfeld
residuals, used to construct an approximate standard error band for
plots.
\item \code{transform} the transformation applied to the time values.
}
}
\description{
Obtains the scaled Schoenfeld residuals and tests the
proportional hazards assumption using a score test for the interaction
between each covariate and a transformed time variable.
}
\details{
This corresponds to the \code{cox.zph} function from the \code{survival}
package with \code{terms = FALSE} and \code{global = TRUE}.
}
\examples{

fit <- phregr(data = liver, time = "Time", event = "Status", 
              covariates = c("log(Bilirubin)", "log(Protime)", 
                             "log(Albumin)", "Age", "Edema"),
              ties = "breslow")
              
zph <- zph_phregr(fit, transform = "log")
  
zph$table

}
\references{
Patricia M. Grambsch and Terry M. Therneau.
Proportional hazards tests and diagnostics based on weighted residuals.
Biometrika 1994; 81:515-26.
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
