% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets_findingemo.R
\name{check_findingemo_quality}
\alias{check_findingemo_quality}
\title{Check FindingEmo Dataset Quality}
\usage{
check_findingemo_quality(data_dir, check_images = FALSE, sample_size = 10)
}
\arguments{
\item{data_dir}{Character. Directory containing the FindingEmo dataset.}

\item{check_images}{Logical. Whether to verify image file accessibility 
(default: FALSE, as this can be slow).}

\item{sample_size}{Integer. If check_images is TRUE, number of images to 
sample for verification (default: 10).}
}
\value{
A list containing:
\itemize{
  \item \code{structure}: Dataset structure type ("standard" or "flat")
  \item \code{files_found}: List of available files
  \item \code{annotations_count}: Number of annotations
  \item \code{urls_count}: Number of image URLs
  \item \code{images_count}: Number of downloaded images
  \item \code{completeness}: Percentage of images successfully downloaded
  \item \code{image_check}: Results of image accessibility check (if performed)
}
}
\description{
Checks the quality and completeness of a downloaded FindingEmo dataset,
reporting on file availability, image accessibility, and potential issues.
}
\examples{
\dontrun{
# Check dataset quality
quality_report <- check_findingemo_quality("./findingemo_data")
print(quality_report)

# Check with image verification
quality_report <- check_findingemo_quality(
  data_dir = "./findingemo_data",
  check_images = TRUE,
  sample_size = 5
)
}

}
