% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roads.R
\name{roads_to_segments}
\alias{roads_to_segments}
\title{Convert road geometries to modeling segments}
\usage{
roads_to_segments(
  roads,
  crs_m = 3857,
  keep_attrs = NULL,
  drop_zero = TRUE,
  split_at_intersections = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{roads}{An `sf` object with LINESTRING or MULTILINESTRING geometries.}

\item{crs_m}{Metric CRS used for length calculation (and intersection splitting)
when `roads` is lon/lat. Default 3857. For best accuracy, pass a local UTM EPSG.}

\item{keep_attrs}{Optional character vector of non-geometry columns to keep.
If `NULL`, keeps all attributes.}

\item{drop_zero}{Logical; drop segments with non-positive length. Default TRUE.}

\item{split_at_intersections}{Logical; if TRUE, split lines at all intersections.
Implemented via GEOS noding (`sf::st_union` + `sf::st_cast`)
Default FALSE.}

\item{verbose}{Logical; emit simple messages about dropped rows. Default FALSE.}
}
\value{
An `sf` with columns:
  * `seg_id` integer 1..n
  * `length_m` numeric meters
  * geometry LINESTRING
  plus kept attributes.
}
\description{
Takes an `sf` object of LINESTRING/MULTILINESTRING road geometries and returns
a segment-level `sf` with stable segment IDs and metric lengths.
}
\details{
v1 behavior:
* Drops Z/M dimensions
* Casts MULTILINESTRING -> LINESTRING (one row per linestring)
* Optionally splits at intersections (noding) when `split_at_intersections=TRUE`
* Computes `length_m` in meters (projects if lon/lat)
* Drops empty and (optionally) zero-length segments
}
