% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surreal-app.R
\name{surreal_app}
\alias{surreal_app}
\title{Launch the Surreal Shiny App}
\usage{
surreal_app(launch.browser = TRUE, port = NULL, host = "127.0.0.1")
}
\arguments{
\item{launch.browser}{Logical. If \code{TRUE} (default), opens the app in the
default web browser. If \code{FALSE}, returns the app URL for manual opening.}

\item{port}{Integer. The port to run the app on. If \code{NULL} (default),
Shiny will choose an available port.}

\item{host}{Character. The host address. Default is \code{"127.0.0.1"} (localhost).}
}
\value{
This function is called for its side effect of launching the Shiny
app. It does not return a value.
}
\description{
Opens an interactive Shiny application for exploring the surreal algorithm.
The app allows you to generate datasets with hidden images in residual plots
using demo data, custom text, or uploaded images.
}
\details{
The app provides:
\itemize{
\item Demo datasets (Jack-o-Lantern, R Logo)
\item Custom text input to embed messages in residual plots
\item Image upload support (PNG, JPEG, BMP, TIFF, SVG)
\item Interactive controls for R², predictors, and image processing settings
\item Dark/light mode toggle
\item Data export to CSV
}
}
\section{Requirements}{

The app requires the \pkg{shiny} and \pkg{bslib} packages to be installed.
For image uploads, additional packages may be needed depending on the format:
\itemize{
\item JPEG: \pkg{jpeg}
\item BMP: \pkg{bmp}
\item TIFF: \pkg{tiff}
\item SVG: \pkg{rsvg}
}
}

\examples{
\dontrun{
# Launch the app in the default browser
surreal_app()

# Launch on a specific port
surreal_app(port = 3838)

# Get the app without launching browser
surreal_app(launch.browser = FALSE)
}

}
\seealso{
\code{\link[=surreal]{surreal()}} for the core algorithm.
\code{\link[=surreal_text]{surreal_text()}} for embedding text programmatically.
\code{\link[=surreal_image]{surreal_image()}} for processing images programmatically.
}
