% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.ci.mean2}
\alias{size.ci.mean2}
\title{Sample size for a 2-group mean difference confidence interval}
\usage{
size.ci.mean2(alpha, var, w, R)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{var}{planning value of average within-group variance}

\item{w}{desired confidence interval width}

\item{R}{n2/n1 ratio}
}
\value{
Returns the required sample size for each group
}
\description{
Computes the sample size for each group required to estimate a population
mean difference with desired confidence interval precision in a 2-group
design. Set the variance planning value to the largest value within a
plausible range for a conservatively large sample size. Set R = 1 for
equal sample sizes. For unequal sample sizes, this function assumes
approximately equal population variances.

For more details, see Section 2.13 of Bonett (2021, Volume 1)
}
\examples{
size.ci.mean2(.01, 81, 12, 1)

# Should return:
# n1  n2
# 32  32

size.ci.mean2(.05, 4.0, 2.5, 2)

# Should return:
# n1  n2
# 16  32
 

}
\references{
\insertRef{Bonett2021}{statpsych}
}
