% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beowulf_cluster.R
\name{beowulf_cluster}
\alias{beowulf_cluster}
\title{Create a Beowulf cluster for parallel computing}
\usage{
beowulf_cluster(
  cluster.ips = NULL,
  cluster.cores = NULL,
  cluster.user = Sys.info()[["user"]],
  cluster.port = "11000",
  outfile = NULL
)
}
\arguments{
\item{cluster.ips}{Character vector of machine IP addresses in the cluster. The first IP is the main node (typically the machine running this code). Default: \code{NULL}.}

\item{cluster.cores}{Integer vector of core counts for each machine. Must match the length of \code{cluster.ips}. Default: \code{NULL}.}

\item{cluster.user}{Character string for the user name across all machines. Default: current system user.}

\item{cluster.port}{Character string specifying the communication port. Default: \code{"11000"}.}

\item{outfile}{Character string or \code{NULL}. Path to append worker messages, \code{""} to print to console, or \code{NULL} (default) for \verb{/dev/null} (Linux) or \verb{nul:} (Windows).}
}
\value{
Cluster object created by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}, ready for registration with \code{\link[doParallel:registerDoParallel]{doParallel::registerDoParallel()}}.
}
\description{
Creates a Beowulf cluster configuration from machine IPs, core counts, and user credentials.
}
\details{
\strong{Network requirements}: Firewalls on all machines must allow traffic on the specified port.

\strong{Usage workflow}:
\enumerate{
\item Create cluster with this function
\item Register with \code{\link[doParallel:registerDoParallel]{doParallel::registerDoParallel()}}
\item Run parallelized code (e.g., foreach loops)
\item Stop cluster with \code{\link[parallel:makeCluster]{parallel::stopCluster()}}
}
}
\examples{
\dontrun{
# Create cluster with 3 machines
beowulf.cluster <- beowulf_cluster(
  cluster.ips = c(
    "192.168.1.10",  # main node
    "192.168.1.11",
    "192.168.1.12"
  ),
  cluster.cores = c(7, 4, 4),
  cluster.user = "username",
  cluster.port = "11000"
)

# Register cluster for parallel processing
doParallel::registerDoParallel(cl = beowulf.cluster)

# Run parallelized code (e.g., foreach loop)
# your_parallel_code_here

# Stop cluster when done
parallel::stopCluster(cl = beowulf.cluster)
}


}
\seealso{
Other utilities: 
\code{\link{.vif_to_df}()},
\code{\link{auc}()},
\code{\link{objects_size}()},
\code{\link{optimization_function}()},
\code{\link{prepare_importance_spatial}()},
\code{\link{rescale_vector}()},
\code{\link{root_mean_squared_error}()},
\code{\link{setup_parallel_execution}()},
\code{\link{standard_error}()},
\code{\link{statistical_mode}()},
\code{\link{thinning}()},
\code{\link{thinning_til_n}()}
}
\concept{utilities}
