% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.raster_cube}
\alias{plot.raster_cube}
\title{Plot RGB data cubes}
\usage{
\method{plot}{raster_cube}(
  x,
  ...,
  band = NULL,
  red = NULL,
  green = NULL,
  blue = NULL,
  tile = x[["tile"]][[1L]],
  dates = NULL,
  roi = NULL,
  palette = "RdYlGn",
  rev = FALSE,
  scale = 1,
  first_quantile = 0.02,
  last_quantile = 0.98,
  max_cog_size = 1024L,
  legend_position = "inside"
)
}
\arguments{
\item{x}{Object of class "raster_cube".}

\item{...}{Further specifications for \link{plot}.}

\item{band}{Band for plotting grey images.}

\item{red}{Band for red color.}

\item{green}{Band for green color.}

\item{blue}{Band for blue color.}

\item{tile}{Tile to be plotted.}

\item{dates}{Dates to be plotted}

\item{roi}{Spatial extent to plot in WGS 84 - named vector
(see notes)}

\item{palette}{An RColorBrewer palette}

\item{rev}{Reverse the color order in the palette?}

\item{scale}{Scale to plot map (0.4 to 1.0)}

\item{first_quantile}{First quantile for stretching images}

\item{last_quantile}{Last quantile for stretching images}

\item{max_cog_size}{Maximum size of COG overviews (lines or columns)}

\item{legend_position}{Where to place the legend (default = "inside")}
}
\value{
A plot object with an RGB image
                      or a B/W image on a color scale
}
\description{
Plot RGB raster cube
}
\note{
Use \code{scale} parameter for general output control.
      The \code{dates} parameter indicates
      the date allows plotting of different dates when
      a single band and three dates are provided, `sits` will plot a
      multi-temporal RGB image for a single band (useful in the case of
      SAR data). For RGB bands with multi-dates, multiple plots will be
      produced.

To see which color palettes are supported, please run cols4all::c4a_gui().

To define a \code{roi} use one of:
     \itemize{
       \item{A path to a shapefile with polygons;}
       \item{A \code{sfc} or \code{sf} object from \code{sf} package;}
       \item{A \code{SpatExtent} object from \code{terra} package;}
       \item{A named \code{vector} (\code{"lon_min"},
            \code{"lat_min"}, \code{"lon_max"}, \code{"lat_max"}) in WGS84;}
       \item{A named \code{vector} (\code{"xmin"}, \code{"xmax"},
             \code{"ymin"}, \code{"ymax"}) with XY coordinates.}
}

If the user does not provide band names for b/w or RGB plots,
and also does not provide dates,
\code{plot.raster_cube} tries to display some reasonable color
composites, using the following algorithm:
\enumerate{
\item{Each image in \code{sits} is associated to a source and
a collection (e.g, "MPC" and "SENTINEL-2-L2A").}
\item{For each source/collection pair, \code{sits} has a set
of possible color composites stored in "./extdata/config_colors.yml".
For example, the following composites are available for all
"SENTINEL-2" images:
     \itemize{
     \item {AGRICULTURE: ("B11", "B08", "B02")}
     \item {AGRICULTURE2: ("B11", "B8A", "B02")}
     \item {SWIR: ("B11", "B08", "B04")}
     \item {SWIR2: ("B12", "B08", "B04")}
     \item {SWIR3: ("B12", "B8A", "B04")}
     \item {RGB: ("B04", "B03", "B02")}
     \item {RGB-FALSE1  : ("B08", "B06", "B04")}
     \item {RGB-FALSE2  : ("B08", "B11", "B04")}
     }
 }
\item{\code{sits} tries to find if the bands required for one
      of the color composites are part of the cube. If they exist,
      that RGB composite is selected. Otherwise, the first
      available band is chosen.}
\item{After selecting the bands, the algorithm looks for the
      date with the smallest percentage of cloud cover and
      selects that date to be displayed.}
}

. The following optional parameters are available to allow for detailed
      control over the plot output:
\itemize{
\item \code{graticules_labels_size}: size of coord labels (default = 0.7)
\item \code{legend_title_size}: size of legend title (default = 0.7)
\item \code{legend_text_size}: size of legend text (default = 0.7)
\item \code{legend_bg_color}: color of legend background (default = "white")
\item \code{legend_bg_alpha}: legend opacity (default = 0.3)
}
}
\examples{
if (sits_run_examples()) {
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )
    # plot NDVI band of the least cloud cover date
    plot(cube)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
