% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_evals.R
\name{plot_evals}
\alias{plot_evals}
\title{Plot one metric versus another for each method}
\usage{
plot_evals(
  object,
  metric_name_x,
  metric_name_y,
  use_ggplot2 = TRUE,
  main,
  facet_mains,
  xlab,
  ylab,
  xlim,
  ylim,
  include_zero = FALSE,
  legend_location = "topright",
  method_col = seq(num_methods),
  method_lty = rep(1, num_methods),
  method_lwd = rep(1, num_methods),
  method_pch = rep(NA, num_methods),
  ...
)
}
\arguments{
\item{object}{an object of class \code{\linkS4class{Simulation}},
\code{\linkS4class{Evals}}, or \code{listofEvals}}

\item{metric_name_x}{the name of metric to plot on x axis (or NULL)}

\item{metric_name_y}{the name of metric to plot on y axis}

\item{use_ggplot2}{whether to use \code{ggplot2} (requires installation
of \code{ggplot2})}

\item{main}{title of plot. Default is \code{model_label} when evals is
a single Evals.}

\item{facet_mains}{only to be used when evals is a \code{listofEvals}
and should be of the same length. Default will be the model_label
for each model.}

\item{xlab}{the x-axis label (default is \code{metric_label_x})}

\item{ylab}{the y-axis label (default is \code{metric_label_y})}

\item{xlim}{the limits of the x-axis}

\item{ylim}{the limits of the y-axis}

\item{include_zero}{whether ylim should include 0.  Ignored if ylim
is passed explicitly}

\item{legend_location}{location of legend.  Set to NULL to remove legend.}

\item{method_col}{color to use for each method}

\item{method_lty}{line style to use for each method}

\item{method_lwd}{line thickness to use for each method}

\item{method_pch}{point style to use for each method (default is that no
points, only lines are drawn)}

\item{...}{additional arguments to pass to \code{boxplot} (only when
\code{use_ggplot2 = FALSE}).}
}
\description{
This function is used when both evaluated metrics are vector-valued, so a
curve is plotted, parametrized by the two metrics.  To plot a single metric
that is vector-valued, pass NULL for metric_name_x. This behaves similarly
to \code{plot(runif(5))}, in which the x-axis variable is simply \code{1:5}.
If evals is a \code{listofEvals}, then each model will be its own plot.
}
