% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabilityClass.R
\name{stabilityClass}
\alias{stabilityClass}
\title{Stability class.}
\usage{
stabilityClass(rad, tcc, ws, option = "iaea")
}
\arguments{
\item{rad}{The net radiation in W/m^2}

\item{tcc}{The total cloud cover in a range from 1 to 8}

\item{ws}{wind speed in m/s}

\item{option}{The method used to determine the stability class. It can be
\code{iaea} (default), \code{pasquill} or \code{custom}.}
}
\value{
\code{stabilityClass} returns a numeric vector with Pasquill
stability classes coded as: A = 1, B = 2, ... , F = 6 ranging from
"very unstable" to "very stable".
}
\description{
Computes stability class given net radiation, total cloud cover and wind
speed.
}
\details{
\code{stabilityClass()} computes stability class according to IAEA method based
on net radiation, total cloud cover tcc and wind speed.
Net radiation and wind are used by day; tcc and wind are used by night.

Three different algorithms are implemented, selected by the \code{option}
argument.

\code{iaea} option implements the *radiation-wind method recommended by the
International Atomic Energy Agency (IAEA) and it is based on the net
radiation during the day and cloud cover by night.

\code{pasquill} option is based on the original Pasquill formulation and
lacks the "very weak" solar insolation present in the modified \code{iaea}
version.

Eventually, the \code{custom} options is similar to \code{iaea},
with slightly different set of parameters for net radiation, wind speed
and cloud cover.

Previously used option \code{impact} is the same as \code{iaea} and it is now
deprecated.
}
\examples{

# Compute stability class with custom algorithm
stMeteo$cst <- stabilityClass(
    rad = stMeteo$rad,
    tcc = stMeteo$tcc,
    ws = stMeteo$ws,
    option = "custom"
)

}
\seealso{
\code{\link[=turnerStabilityClass]{turnerStabilityClass()}} which computes stability class with Turner method.
\code{\link[=plotStabilityClass]{plotStabilityClass()}} to produce graphical outputs with stability class.
}
