% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{SimPhiN2}
\alias{SimPhiN2}
\title{Simulate Random Drift Matrices
from the Multivariate Normal Distribution
and Project to Hurwitz}
\usage{
SimPhiN2(n, phi, vcov_phi_vec_l, margin = 0.001)
}
\arguments{
\item{n}{Positive integer.
Number of replications.}

\item{phi}{Numeric matrix.
The drift matrix (\eqn{\boldsymbol{\Phi}}).}

\item{vcov_phi_vec_l}{Numeric matrix.
Cholesky factorization (\code{t(chol(vcov_phi_vec))})
of the sampling variance-covariance matrix of
\eqn{\mathrm{vec} \left( \boldsymbol{\Phi} \right)}.}

\item{margin}{Positive numeric.
Target buffer so that the spectral abscissa
is \eqn{\le -\text{margin}} (default \code{1e-3}).}
}
\value{
Returns a list of random drift matrices.
}
\description{
This function simulates random dirft matrices
from the multivariate normal distribution
then projects each draw to the Hurwitz-stable region
using \code{\link[=ProjectToHurwitz]{ProjectToHurwitz()}}.
}
\examples{
n <- 10
phi <- matrix(
  data = c(
    -0.357, 0.771, -0.450,
    0.0, -0.511, 0.729,
    0, 0, -0.693
  ),
  nrow = 3
)
vcov_phi_vec_l <- t(chol(0.001 * diag(9)))
SimPhiN2(n = n, phi = phi, vcov_phi_vec_l = vcov_phi_vec_l)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{LinSDECovEta}()},
\code{\link{LinSDECovY}()},
\code{\link{LinSDEMeanEta}()},
\code{\link{LinSDEMeanY}()},
\code{\link{ProjectToHurwitz}()},
\code{\link{ProjectToStability}()},
\code{\link{SSMCovEta}()},
\code{\link{SSMCovY}()},
\code{\link{SSMMeanEta}()},
\code{\link{SSMMeanY}()},
\code{\link{SimAlphaN}()},
\code{\link{SimBetaN}()},
\code{\link{SimBetaN2}()},
\code{\link{SimBetaNCovariate}()},
\code{\link{SimCovDiagN}()},
\code{\link{SimCovN}()},
\code{\link{SimIotaN}()},
\code{\link{SimNuN}()},
\code{\link{SimPhiN}()},
\code{\link{SimPhiNCovariate}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{SpectralRadius}()},
\code{\link{TestPhi}()},
\code{\link{TestPhiHurwitz}()},
\code{\link{TestStability}()},
\code{\link{TestStationarity}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{linsde}
\keyword{simStateSpace}
