% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simStateSpace-lin-sde-cov-eta.R
\name{LinSDECovEta}
\alias{LinSDECovEta}
\title{Steady-State Covariance Matrix for the
Latent Variables in the
Linear Stochastic Differential Equation Model}
\usage{
LinSDECovEta(phi, sigma)
}
\arguments{
\item{phi}{Numeric matrix.
The drift matrix
which represents the rate of change of the solution
in the absence of any random fluctuations
(\eqn{\boldsymbol{\Phi}}).}

\item{sigma}{Numeric matrix.
The covariance matrix of volatility
or randomness in the process
(\eqn{\boldsymbol{\Sigma}}).}
}
\description{
The steady-state covariance matrix
for the latent variables
in the linear stochastic differential equation model
\eqn{\mathrm{Cov} \left( \boldsymbol{\eta} \right)}
is the solution
to the Sylvester equation,
i.e.
\deqn{
  \mathbf{A} \mathbf{X} +
  \mathbf{X} \mathbf{B} +
  \mathbf{C} = \mathbf{0} ,
} where \eqn{\mathbf{X}} is unknown,
\eqn{\mathbf{A} = \boldsymbol{\Phi}},
\eqn{\mathbf{B} = \boldsymbol{\Phi}^{\prime}}, and
\eqn{\mathbf{C} = \boldsymbol{\Sigma}}
where
\eqn{\boldsymbol{\Phi}}
is the drift matrix
and
\eqn{\boldsymbol{\Sigma}}
is the covariance matrix
of volatility or randomness in the process.
}
\examples{
phi <- matrix(
  data = c(
    -0.357, 0.771, -0.450,
    0.0, -0.511, 0.729,
    0.0, 0.0, -0.693
  ),
  nrow = 3
)
sigma <- matrix(
  data = c(
    0.24455556, 0.02201587, -0.05004762,
    0.02201587, 0.07067800, 0.01539456,
    -0.05004762, 0.01539456, 0.07553061
  ),
  nrow = 3
)
LinSDECovEta(
  phi = phi,
  sigma = sigma
)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{LinSDECovY}()},
\code{\link{LinSDEMeanEta}()},
\code{\link{LinSDEMeanY}()},
\code{\link{ProjectToHurwitz}()},
\code{\link{ProjectToStability}()},
\code{\link{SSMCovEta}()},
\code{\link{SSMCovY}()},
\code{\link{SSMMeanEta}()},
\code{\link{SSMMeanY}()},
\code{\link{SimAlphaN}()},
\code{\link{SimBetaN}()},
\code{\link{SimBetaN2}()},
\code{\link{SimBetaNCovariate}()},
\code{\link{SimCovDiagN}()},
\code{\link{SimCovN}()},
\code{\link{SimIotaN}()},
\code{\link{SimNuN}()},
\code{\link{SimPhiN}()},
\code{\link{SimPhiN2}()},
\code{\link{SimPhiNCovariate}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{SpectralRadius}()},
\code{\link{TestPhi}()},
\code{\link{TestPhiHurwitz}()},
\code{\link{TestStability}()},
\code{\link{TestStationarity}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{linsde}
\keyword{simStateSpace}
