% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.bench.R
\name{summary.bench}
\alias{summary.bench}
\title{Method for the summary of the STF}
\usage{
\method{summary}{bench}(object, ...)
}
\arguments{
\item{object}{Object of class \code{bench()}}

\item{...}{other arguments}
}
\value{
A summary of the STF obtained from the application of the benchmark procedure
}
\description{
The STF is obtained with the benchmark procedure implemented in the function \code{bench()}
}
\examples{
set.seed(123)
n <- 50
theta <- rnorm(500)
item_par <- data.frame(
  b = runif(n, -3, 3),
  a = runif(n, 1.2, 1.9),
  c = rep(0, n),
  e = rep(1, n)
)
resB <- bench(item_par, theta = theta, num_item = 5)
summary(resB)
}
